/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.SimpleQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.junit.Test;

public class DateTimeTypesSimpleCodecTest
extends SimpleQueryDataTypeCodecTestBase {
    private static final LocalDateTime NOW = LocalDateTime.now(ZoneOffset.UTC);
    private static final LocalDateTime TODAY = LocalDateTime.of(NOW.toLocalDate(), LocalTime.MIDNIGHT);

    @Test
    public void testDate(TestContext ctx) {
        this.testDate(ctx, "1981-05-30", LocalDate.parse("1981-05-30"));
    }

    @Test
    public void testDatePlusToday(TestContext ctx) {
        this.testDate(ctx, "today", TODAY.toLocalDate());
    }

    @Test
    public void testDatePlusInfinity(TestContext ctx) {
        this.testDate(ctx, "infinity", LocalDate.MAX);
    }

    @Test
    public void testDateMinusInfinity(TestContext ctx) {
        this.testDate(ctx, "-infinity", LocalDate.MIN);
    }

    private void testDate(TestContext ctx, String value, LocalDate ld) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(v -> conn.query("SELECT '" + value + "'::DATE \"LocalDate\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"LocalDate").returns(Tuple::getValue, Row::getValue, (Object)ld).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ld).returns(Tuple::getTemporal, Row::getTemporal, (Object)ld).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testTime(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '17:55:04.905120'::TIME \"LocalTime\"").execute(ctx.asyncAssertSuccess(result -> {
            LocalTime lt = LocalTime.parse("17:55:04.905120");
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"LocalTime").returns(Tuple::getValue, Row::getValue, (Object)lt).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)lt).returns(Tuple::getTemporal, Row::getTemporal, (Object)lt).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testTimeTz(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '17:55:04.90512+03:07'::TIMETZ \"OffsetTime\"").execute(ctx.asyncAssertSuccess(result -> {
            OffsetTime ot = OffsetTime.parse("17:55:04.905120+03:07");
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"OffsetTime").returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)ot).returns(Tuple::getTemporal, Row::getTemporal, (Object)ot).returns(Tuple::getValue, Row::getValue, (Object)ot).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testTimestamp(TestContext ctx) {
        this.testTimestamp(ctx, "2017-05-14 19:35:58.237666", LocalDateTime.parse("2017-05-14T19:35:58.237666"));
    }

    @Test
    public void testTimestampToday(TestContext ctx) {
        this.testTimestamp(ctx, "today", TODAY);
    }

    @Test
    public void testTimestampPlusInfinity(TestContext ctx) {
        this.testTimestamp(ctx, "infinity", LocalDateTime.MAX);
    }

    @Test
    public void testTimestampMinusInfinity(TestContext ctx) {
        this.testTimestamp(ctx, "-infinity", LocalDateTime.MIN);
    }

    private void testTimestamp(TestContext ctx, String value, LocalDateTime expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '" + value + "'::TIMESTAMP \"LocalDateTime\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"LocalDateTime").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testTimestampTz(TestContext ctx) {
        this.testTimestampTz(ctx, "2017-05-14 22:35:58.237666-03", OffsetDateTime.parse("2017-05-15T01:35:58.237666Z"));
    }

    @Test
    public void testTimestampTzToday(TestContext ctx) {
        this.testTimestampTz(ctx, "today", OffsetDateTime.of(TODAY, ZoneOffset.UTC));
    }

    @Test
    public void testTimestampTzPlusInfinity(TestContext ctx) {
        this.testTimestampTz(ctx, "infinity", OffsetDateTime.MAX);
    }

    @Test
    public void testTimestampTzMinusInfinity(TestContext ctx) {
        this.testTimestampTz(ctx, "-infinity", OffsetDateTime.MIN);
    }

    private void testTimestampTz(TestContext ctx, String value, OffsetDateTime expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(v -> conn.query("SELECT '" + value + "'::TIMESTAMPTZ \"OffsetDateTime\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"OffsetDateTime").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)expected.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)expected).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testInterval(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '10 years 3 months 332 days 20 hours 20 minutes 20.999991 seconds'::INTERVAL \"Interval\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            Interval interval = Interval.of().years(10).months(3).days(332).hours(20).minutes(20).seconds(20).microseconds(999991);
            ColumnChecker.checkColumn((int)0, (String)"Interval").returns(Tuple::getValue, Row::getValue, (Object)interval).returns(Interval.class, (Object)interval).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testDecodeDATEArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['1998-05-11' :: DATE, '1998-05-11' :: DATE]", "LocalDate", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfLocalDates), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfLocalDates), LocalDate.parse("1998-05-11"), LocalDate.parse("1998-05-11"));
    }

    @Test
    public void testDecodeTIMEArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['17:55:04.90512' :: TIME WITHOUT TIME ZONE]", "LocalTime", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfLocalTimes), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfLocalTimes), lt);
    }

    @Test
    public void testDecodeTIMETZArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['17:55:04.90512+03' :: TIME WITH TIME ZONE]", "OffsetTime", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfOffsetTimes), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfOffsetTimes), dt);
    }

    @Test
    public void testDecodeTIMESTAMPArray(TestContext ctx) {
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"LocalDateTime").returns(Tuple::getValue, Row::getValue, new Object[]{ldt}).returns(Tuple::getArrayOfLocalTimes, Row::getArrayOfLocalTimes, new Object[]{ldt.toLocalTime()}).returns(Tuple::getArrayOfLocalDates, Row::getArrayOfLocalDates, new Object[]{ldt.toLocalDate()}).returns(Tuple::getArrayOfLocalDateTimes, Row::getArrayOfLocalDateTimes, new Object[]{ldt});
        this.testDecodeGenericArray(ctx, "ARRAY ['2017-05-14 19:35:58.237666' :: TIMESTAMP WITHOUT TIME ZONE]", "LocalDateTime", checker);
    }

    @Test
    public void testDecodeTIMESTAMPTZArray(TestContext ctx) {
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"OffsetDateTime").returns(Tuple::getValue, Row::getValue, new Object[]{odt}).returns(Tuple::getArrayOfOffsetTimes, Row::getArrayOfOffsetTimes, new Object[]{odt.toOffsetTime()}).returns(Tuple::getArrayOfOffsetDateTimes, Row::getArrayOfOffsetDateTimes, new Object[]{odt});
        this.testDecodeGenericArray(ctx, "ARRAY ['2017-05-14 23:59:59.237666-03' :: TIMESTAMP WITH TIME ZONE]", "OffsetDateTime", checker);
    }

    @Test
    public void testDecodeINTERVALArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['10 years 3 months 332 days 20 hours 20 minutes 20.999991 seconds'::INTERVAL, '20 minutes 20.123456 seconds'::INTERVAL, '30 months ago'::INTERVAL]", "Interval", Interval.class, intervals);
    }
}

