/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;

public abstract class DataTypeTestBase
extends PgTestBase {
    protected Vertx vertx;
    protected static final UUID uuid = UUID.fromString("6f790482-b5bd-438b-a8b7-4a0bed747011");
    protected static final LocalDateTime ldt = LocalDateTime.parse("2017-05-14T19:35:58.237666");
    protected static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSS");
    protected static final LocalTime lt = LocalTime.parse("17:55:04.90512", dtf);
    protected static final OffsetTime dt = OffsetTime.parse("17:55:04.90512+03:00");
    protected static final OffsetDateTime odt = OffsetDateTime.parse("2017-05-15T02:59:59.237666Z");
    protected static final Interval[] intervals = new Interval[]{Interval.of().years(10).months(3).days(332).hours(20).minutes(20).seconds(20).microseconds(999991), Interval.of().minutes(20).seconds(20).microseconds(123456), Interval.of().years(-2).months(-6)};

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    static {
        ColumnChecker.load(() -> {
            ArrayList<Object> tupleMethods = new ArrayList<Object>();
            tupleMethods.add(Tuple::getValue);
            tupleMethods.add(Tuple::getShort);
            tupleMethods.add(Tuple::getInteger);
            tupleMethods.add(Tuple::getLong);
            tupleMethods.add(Tuple::getFloat);
            tupleMethods.add(Tuple::getDouble);
            tupleMethods.add(Tuple::getBigDecimal);
            tupleMethods.add(Tuple::getString);
            tupleMethods.add(Tuple::getBoolean);
            tupleMethods.add(Tuple::getJsonObject);
            tupleMethods.add(Tuple::getArrayOfJsonArrays);
            tupleMethods.add(Tuple::getBuffer);
            tupleMethods.add(Tuple::getBuffer);
            tupleMethods.add(Tuple::getTemporal);
            tupleMethods.add(Tuple::getLocalDate);
            tupleMethods.add(Tuple::getLocalTime);
            tupleMethods.add(Tuple::getOffsetTime);
            tupleMethods.add(Tuple::getLocalDateTime);
            tupleMethods.add(Tuple::getOffsetDateTime);
            tupleMethods.add(Tuple::getArrayOfBooleans);
            tupleMethods.add(Tuple::getArrayOfJsonObjects);
            tupleMethods.add(Tuple::getArrayOfJsonArrays);
            tupleMethods.add(Tuple::getArrayOfShorts);
            tupleMethods.add(Tuple::getArrayOfIntegers);
            tupleMethods.add(Tuple::getArrayOfLongs);
            tupleMethods.add(Tuple::getArrayOfFloats);
            tupleMethods.add(Tuple::getArrayOfDoubles);
            tupleMethods.add(Tuple::getArrayOfNumerics);
            tupleMethods.add(Tuple::getArrayOfStrings);
            tupleMethods.add(Tuple::getArrayOfLocalDates);
            tupleMethods.add(Tuple::getArrayOfLocalTimes);
            tupleMethods.add(Tuple::getArrayOfOffsetTimes);
            tupleMethods.add(Tuple::getArrayOfLocalDateTimes);
            tupleMethods.add(Tuple::getArrayOfBuffers);
            tupleMethods.add(Tuple::getArrayOfUUIDs);
            tupleMethods.add(ColumnChecker.getByIndex(Point.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(Point.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(Line.class));
            tupleMethods.add(ColumnChecker.getByIndex(Line.class));
            tupleMethods.add(ColumnChecker.getByIndex(LineSegment.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(LineSegment.class));
            tupleMethods.add(ColumnChecker.getByIndex(LineSegment.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(LineSegment.class));
            tupleMethods.add(ColumnChecker.getByIndex(Path.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(Path.class));
            tupleMethods.add(ColumnChecker.getByIndex(Polygon.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(Polygon.class));
            tupleMethods.add(ColumnChecker.getByIndex(Circle.class));
            tupleMethods.add(ColumnChecker.getValuesByIndex(Circle.class));
            return tupleMethods;
        }, () -> {
            ArrayList<Object> rowMethods = new ArrayList<Object>();
            rowMethods.add(Row::getValue);
            rowMethods.add(Row::getShort);
            rowMethods.add(Row::getInteger);
            rowMethods.add(Row::getLong);
            rowMethods.add(Row::getFloat);
            rowMethods.add(Row::getDouble);
            rowMethods.add(Row::getBigDecimal);
            rowMethods.add(Row::getString);
            rowMethods.add(Row::getBoolean);
            rowMethods.add(Row::getJsonObject);
            rowMethods.add(Row::getJsonArray);
            rowMethods.add(Row::getBuffer);
            rowMethods.add(Row::getBuffer);
            rowMethods.add(Row::getTemporal);
            rowMethods.add(Row::getLocalDate);
            rowMethods.add(Row::getLocalTime);
            rowMethods.add(Row::getOffsetTime);
            rowMethods.add(Row::getLocalDateTime);
            rowMethods.add(Row::getOffsetDateTime);
            rowMethods.add(Row::getArrayOfBooleans);
            rowMethods.add(Row::getArrayOfJsonObjects);
            rowMethods.add(Row::getArrayOfJsonArrays);
            rowMethods.add(Row::getArrayOfShorts);
            rowMethods.add(Row::getArrayOfIntegers);
            rowMethods.add(Row::getArrayOfLongs);
            rowMethods.add(Row::getArrayOfFloats);
            rowMethods.add(Row::getArrayOfDoubles);
            rowMethods.add(Row::getArrayOfNumerics);
            rowMethods.add(Row::getArrayOfStrings);
            rowMethods.add(Row::getArrayOfLocalDates);
            rowMethods.add(Row::getArrayOfLocalTimes);
            rowMethods.add(Row::getArrayOfOffsetTimes);
            rowMethods.add(Row::getArrayOfLocalDateTimes);
            rowMethods.add(Row::getArrayOfBuffers);
            rowMethods.add(Row::getArrayOfUUIDs);
            rowMethods.add(ColumnChecker.getByName(Point.class));
            rowMethods.add(ColumnChecker.getValuesByName(Point.class));
            rowMethods.add(ColumnChecker.getValuesByName(Line.class));
            rowMethods.add(ColumnChecker.getByName(Line.class));
            rowMethods.add(ColumnChecker.getByName(LineSegment.class));
            rowMethods.add(ColumnChecker.getValuesByName(LineSegment.class));
            rowMethods.add(ColumnChecker.getByName(LineSegment.class));
            rowMethods.add(ColumnChecker.getValuesByName(LineSegment.class));
            rowMethods.add(ColumnChecker.getByName(Path.class));
            rowMethods.add(ColumnChecker.getValuesByName(Path.class));
            rowMethods.add(ColumnChecker.getByName(Polygon.class));
            rowMethods.add(ColumnChecker.getValuesByName(Polygon.class));
            rowMethods.add(ColumnChecker.getByName(Circle.class));
            rowMethods.add(ColumnChecker.getValuesByName(Circle.class));
            return rowMethods;
        });
    }
}

