/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;

public class CharacterTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeName(TestContext ctx) {
        this.testDecode(ctx, "SELECT 'What is my name ?'::NAME", Tuple::getString, "What is my name ?");
    }

    @Test
    public void testEncodeName(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"Name\" = upper($1) WHERE \"id\" = $2 RETURNING \"Name\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("vert.x").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            String name = "VERT.X";
            ColumnChecker.checkColumn((int)0, (String)"Name").returns(Tuple::getValue, Row::getValue, (Object)name).returns(Tuple::getString, Row::getString, (Object)name).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeChar(TestContext ctx) {
        this.testDecode(ctx, "SELECT 'A'::CHAR", Tuple::getString, "A");
    }

    @Test
    public void testEncodeChar(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"SingleChar\" = upper($1) WHERE \"id\" = $2 RETURNING \"SingleChar\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("b").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            String singleChar = "B";
            ColumnChecker.checkColumn((int)0, (String)"SingleChar").returns(Tuple::getValue, Row::getValue, (Object)singleChar).returns(Tuple::getString, Row::getString, (Object)singleChar).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeFixedChar(TestContext ctx) {
        this.testDecode(ctx, "SELECT 'YES'::CHAR(3)", Tuple::getString, "YES");
    }

    @Test
    public void testEncodeFixedChar(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"FixedChar\" = upper($1) WHERE \"id\" = $2 RETURNING \"FixedChar\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("no").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            String name = "NO ";
            ColumnChecker.checkColumn((int)0, (String)"FixedChar").returns(Tuple::getValue, Row::getValue, (Object)name).returns(Tuple::getString, Row::getString, (Object)name).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeText(TestContext ctx) {
        this.testDecode(ctx, "SELECT 'Hello World'::TEXT", Tuple::getString, "Hello World");
    }

    @Test
    public void testEncodeText(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"Text\" = upper($1) WHERE \"id\" = $2 RETURNING \"Text\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("Hello World").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            String name = "HELLO WORLD";
            ColumnChecker.checkColumn((int)0, (String)"Text").returns(Tuple::getValue, Row::getValue, (Object)name).returns(Tuple::getString, Row::getString, (Object)name).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeVarchar(TestContext ctx) {
        this.testDecode(ctx, "SELECT 'Great!'::VARCHAR", Tuple::getString, "Great!");
    }

    @Test
    public void testEncodeVarCharacter(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"VarCharacter\" = upper($1) WHERE \"id\" = $2 RETURNING \"VarCharacter\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("Great!").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            String name = "GREAT!";
            ColumnChecker.checkColumn((int)0, (String)"VarCharacter").returns(Tuple::getValue, Row::getValue, (Object)name).returns(Tuple::getString, Row::getString, (Object)name).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeLargeVarchar(TestContext ctx) {
        int len = 2048;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.append((char)(65 + i % 26));
        }
        String value = builder.toString();
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1::VARCHAR(" + len + ")", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)value), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)value, (Object)((Row)result.iterator().next()).getString(0));
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeTextArray(TestContext ctx) {
        this.testDecode(ctx, "SELECT '{ \"Knock, knock.Who\u2019s there?very long pause... Java.\" }'::TEXT[]", Tuple::getArrayOfStrings, new Object[]{new String[]{"Knock, knock.Who\u2019s there?very long pause... Java."}});
    }

    @Test
    public void testEncodeStringArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Text\" = $1  WHERE \"id\" = $2 RETURNING \"Text\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfString(new String[]{"Knock, knock.Who\u2019s there?"}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Text").returns(Tuple::getValue, Row::getValue, (Object[])new String[]{"Knock, knock.Who\u2019s there?"}).returns(Tuple::getArrayOfStrings, Row::getArrayOfStrings, (Object[])new String[]{"Knock, knock.Who\u2019s there?"}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }
}

