/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;

public class BooleanTypeExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeBoolean(TestContext ctx) {
        this.testDecode(ctx, "SELECT true", Tuple::getBoolean, true);
    }

    @Test
    public void testEncodeBoolean(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Boolean\" = $1  WHERE \"id\" = $2 RETURNING \"Boolean\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addBoolean(Boolean.FALSE).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Boolean").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeBooleanArray(TestContext ctx) {
        this.testDecode(ctx, "SELECT '{ true, false }'::BOOL[]", Tuple::getArrayOfBooleans, new Object[]{new Boolean[]{true, false}});
    }

    @Test
    public void testDecodeBooleanArray_(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Boolean\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Boolean").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new boolean[]{Boolean.TRUE})).returns(Tuple::getArrayOfBooleans, Row::getArrayOfBooleans, ColumnChecker.toObjectArray((Object)new boolean[]{Boolean.TRUE})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeBooleanArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Boolean\" = $1  WHERE \"id\" = $2 RETURNING \"Boolean\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfBoolean(new Boolean[]{Boolean.FALSE, Boolean.TRUE}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Boolean").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new boolean[]{Boolean.FALSE, Boolean.TRUE})).returns(Tuple::getArrayOfBooleans, Row::getArrayOfBooleans, ColumnChecker.toObjectArray((Object)new boolean[]{Boolean.FALSE, Boolean.TRUE})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }
}

