/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class BinaryDataTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testBytea(TestContext ctx) {
        Random r = new Random();
        int len = 2048;
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1::BYTEA \"Bytea\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)Buffer.buffer((byte[])bytes)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Bytea").returns(Tuple::getValue, Row::getValue, (Object)Buffer.buffer((byte[])bytes)).returns(Tuple::getBuffer, Row::getBuffer, buffer -> {
                Assert.assertFalse((boolean)buffer.getByteBuf().isDirect());
                Assert.assertEquals((Object)Buffer.buffer((byte[])bytes), (Object)buffer);
            }).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testBufferArray(TestContext ctx) {
        Random r = new Random();
        int len = 2048;
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT ARRAY[$1::BYTEA] \"Bytea\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)Buffer.buffer((byte[])bytes)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Bytea").returns(Tuple::getValue, Row::getValue, (Object[])new Buffer[]{Buffer.buffer((byte[])bytes)}).returns(Tuple::getArrayOfBuffers, Row::getArrayOfBuffers, (Object[])new Buffer[]{Buffer.buffer((byte[])bytes)}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }
}

