/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.junit.ContainerPgRule;
import io.vertx.sqlclient.Tuple;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TLSTest {
    @ClassRule
    public static ContainerPgRule rule = new ContainerPgRule().ssl(true);
    private Vertx vertx;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testTLS(TestContext ctx) {
        Async async = ctx.async();
        PgConnectOptions options = new PgConnectOptions(rule.options()).setSslMode(SslMode.REQUIRE).setPemTrustOptions(new PemTrustOptions().addCertPath("tls/server.crt"));
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)options.setSslMode(SslMode.REQUIRE), (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT * FROM Fortune WHERE id=1").execute(ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                Tuple row = (Tuple)result.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                async.complete();
            }));
        }));
    }

    @Test
    public void testTLSTrustAll(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)rule.options().setSslMode(SslMode.REQUIRE).setTrustAll(true), (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            async.complete();
        }));
    }

    @Test
    public void testTLSInvalidCertificate(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)rule.options().setSslMode(SslMode.REQUIRE), (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertEquals((Object)err.getMessage(), (Object)"SSL handshake failed");
            async.complete();
        }));
    }

    @Test
    public void testSslModeDisable(TestContext ctx) {
        Async async = ctx.async();
        PgConnectOptions options = rule.options().setSslMode(SslMode.DISABLE);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(options), (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertFalse(conn.isSSL());
            async.complete();
        }));
    }

    @Test
    public void testSslModeAllow(TestContext ctx) {
        Async async = ctx.async();
        PgConnectOptions options = rule.options().setSslMode(SslMode.ALLOW);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(options), (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertFalse(conn.isSSL());
            async.complete();
        }));
    }

    @Test
    public void testSslModePrefer(TestContext ctx) {
        Async async = ctx.async();
        PgConnectOptions options = rule.options().setSslMode(SslMode.PREFER).setTrustAll(true);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(options), (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            async.complete();
        }));
    }

    @Test
    public void testSslModeVerifyCaConf(TestContext ctx) {
        PgConnectOptions options = rule.options().setSslMode(SslMode.VERIFY_CA).setTrustAll(true);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(options), (Handler)ctx.asyncAssertFailure(error -> ctx.assertEquals((Object)"Trust options must be specified under verify-full or verify-ca sslmode", (Object)error.getMessage())));
    }

    @Test
    public void testSslModeVerifyFullConf(TestContext ctx) {
        PgConnectOptions options = rule.options().setSslMode(SslMode.VERIFY_FULL);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(options), (Handler)ctx.asyncAssertFailure(error -> ctx.assertEquals((Object)"Host verification algorithm must be specified under verify-full sslmode", (Object)error.getMessage())));
    }
}

