/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.PgTestBase;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class SharedPoolTest
extends PgTestBase {
    private static final String COUNT_CONNECTIONS_QUERY = "SELECT count(*) FROM pg_stat_activity WHERE application_name LIKE '%vertx%'";
    Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testUseSamePool(final TestContext ctx) {
        final int maxSize = 8;
        int instances = maxSize * 4;
        this.vertx.deployVerticle(() -> new AbstractVerticle(){
            PgPool pool;

            public void start() {
                this.pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)SharedPoolTest.this.options, (PoolOptions)new PoolOptions().setMaxSize(maxSize).setShared(true));
                this.pool.query("SELECT pg_sleep(0.5);SELECT count(*) FROM pg_stat_activity WHERE application_name LIKE '%vertx%'").execute(ctx.asyncAssertSuccess(rows -> ctx.assertTrue(((Row)rows.next().iterator().next()).getInteger(0) <= maxSize)));
            }
        }, new DeploymentOptions().setInstances(instances), ctx.asyncAssertSuccess());
    }

    @Test
    public void testCloseAutomatically(final TestContext ctx) {
        final int maxSize = 8;
        int instances = maxSize * 4;
        final Async latch = ctx.async(instances);
        AtomicReference deployment = new AtomicReference();
        Async async = ctx.async();
        this.vertx.deployVerticle(() -> new AbstractVerticle(){
            PgPool pool;

            public void start() {
                this.pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)SharedPoolTest.this.options, (PoolOptions)new PoolOptions().setMaxSize(maxSize).setShared(true));
                this.pool.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> latch.countDown()));
            }
        }, new DeploymentOptions().setInstances(instances), ctx.asyncAssertSuccess(deployment::set));
        latch.awaitSuccess(20000L);
        this.vertx.undeploy((String)deployment.get()).compose(v -> PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options)).compose(conn -> this.waitUntilConnCountIs((SqlConnection)conn, 10, 1)).onComplete(ctx.asyncAssertSuccess(v -> async.complete()));
    }

    private Future<Void> waitUntilConnCountIs(SqlConnection conn, int remaining, int expectedCount) {
        if (remaining > 0) {
            return conn.query(COUNT_CONNECTIONS_QUERY).execute().compose(res -> {
                int num = ((Row)res.iterator().next()).getInteger(0);
                if (num == expectedCount) {
                    return Future.succeededFuture();
                }
                return this.waitUntilConnCountIs(conn, remaining - 1, expectedCount);
            });
        }
        return Future.failedFuture((String)"Could not count");
    }

    @Test
    public void testPartialClose(final TestContext ctx) {
        final int maxSize = 8;
        final int instances = maxSize * 4;
        final Async async = ctx.async();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){
            PgPool pool;

            public void start() {
                this.pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)SharedPoolTest.this.options, (PoolOptions)new PoolOptions().setMaxSize(maxSize).setShared(true));
                this.vertx.deployVerticle(() -> new AbstractVerticle(){

                    public void start(Promise<Void> startPromise) {
                        PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)SharedPoolTest.this.options, (PoolOptions)new PoolOptions().setMaxSize(maxSize).setShared(true));
                        pool.query("SELECT 1").execute().mapEmpty().onComplete(startPromise);
                    }
                }, new DeploymentOptions().setInstances(instances), ctx.asyncAssertSuccess(id -> this.pool.query(SharedPoolTest.COUNT_CONNECTIONS_QUERY).execute(ctx.asyncAssertSuccess(res1 -> {
                    int num1 = ((Row)res1.iterator().next()).getInteger(0);
                    ctx.assertTrue(num1 <= maxSize);
                    this.vertx.undeploy(id).compose(v -> this.pool.query(SharedPoolTest.COUNT_CONNECTIONS_QUERY).execute()).onComplete(ctx.asyncAssertSuccess(res2 -> {
                        int num2 = ((Row)res1.iterator().next()).getInteger(0);
                        ctx.assertEquals((Object)num1, (Object)num2);
                        async.complete();
                    }));
                }))));
            }
        });
    }
}

