/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.Tuple;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PreparedStatementTestBase
extends PgTestBase {
    Vertx vertx;
    public static final Tuple INVALID_TUPLE = Tuple.of((Object)"invalid-id");

    protected abstract PgConnectOptions options();

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testQuery1Param(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
            ctx.assertEquals((Object)1, (Object)results.size());
            Tuple row = (Tuple)results.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            ps.close(ctx.asyncAssertSuccess(ar -> async.complete()));
        }))))));
    }

    @Test
    public void testQuery(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune WHERE id=$1 OR id=$2 OR id=$3 OR id=$4 OR id=$5 OR id=$6", ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9), ctx.asyncAssertSuccess(results -> {
            ctx.assertEquals((Object)6, (Object)results.size());
            ps.close(ctx.asyncAssertSuccess(result -> async.complete()));
        }))))));
    }

    @Test
    public void testCollectorQuery(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune WHERE id=$1 OR id=$2 OR id=$3 OR id=$4 OR id=$5 OR id=$6", ctx.asyncAssertSuccess(ps -> ps.query().collecting(Collectors.toList()).execute(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9), ctx.asyncAssertSuccess(results -> {
            ctx.assertEquals((Object)6, (Object)results.size());
            List list = (List)results.value();
            ctx.assertEquals((Object)list.size(), (Object)6);
            ctx.assertEquals((Object)6L, (Object)list.stream().distinct().count());
            ps.close(ctx.asyncAssertSuccess(result -> async.complete()));
        }))))));
    }

    @Test
    public void testMappedQuery(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: INT4", ctx.asyncAssertSuccess(ps -> ps.query().mapping(row -> "" + row.getInteger(0)).execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
            ctx.assertEquals((Object)1, (Object)results.size());
            RowSet rows = (RowSet)results.value();
            ctx.assertEquals((Object)rows.size(), (Object)1);
            RowIterator it = rows.iterator();
            ctx.assertEquals((Object)"1", it.next());
            ps.close(ctx.asyncAssertSuccess(result -> async.complete()));
        }))))));
    }

    @Test
    public void testQueryParseError(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("invalid", ctx.asyncAssertFailure(err -> {
            PgException pgErr = (PgException)err;
            ctx.assertEquals((Object)"42601", (Object)pgErr.getCode());
            async.complete();
        }))));
    }

    private void testValidationError(TestContext ctx, BiConsumer<PgConnection, Handler<Throwable>> test) {
        int times = 3;
        Async async = ctx.async(times);
        Consumer<Throwable> check = failure -> ctx.assertEquals((Object)"Parameter at position[0] with class = [java.lang.String] and value = [invalid-id] can not be coerced to the expected class = [java.lang.Number] for encoding.", (Object)failure.getMessage());
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> {
            for (int i = 0; i < times; ++i) {
                test.accept((PgConnection)conn, failure1 -> {
                    check.accept((Throwable)failure1);
                    test.accept((PgConnection)conn, failure2 -> {
                        check.accept((Throwable)failure2);
                        test.accept((PgConnection)conn, failure3 -> {
                            check.accept((Throwable)failure3);
                            async.countDown();
                        });
                    });
                });
            }
        }));
    }

    @Test
    public void testPrepareExecuteValidationError(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> ps.query().execute(INVALID_TUPLE, ctx.asyncAssertFailure(cont)))));
    }

    @Test
    public void testPreparedQueryValidationError(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.preparedQuery("SELECT * FROM Fortune WHERE id=$1").execute(INVALID_TUPLE, ctx.asyncAssertFailure(cont)));
    }

    @Test
    public void testPreparedQueryValidationError_(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.preparedQuery("SELECT * FROM Fortune WHERE id=$1").execute(INVALID_TUPLE, ctx.asyncAssertFailure(cont)));
    }

    @Test
    public void testPrepareCursorValidationError(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> {
            Cursor cursor = ps.cursor(INVALID_TUPLE);
            cursor.read(10, ctx.asyncAssertFailure(cont));
        })));
    }

    @Test
    public void testPrepareBatchValidationError(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> ps.query().executeBatch(Collections.singletonList(INVALID_TUPLE), ctx.asyncAssertFailure(cont)))));
    }

    @Test
    public void testPreparedBatchValidationError(TestContext ctx) {
        this.testValidationError(ctx, (conn, cont) -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> ps.query().executeBatch(Collections.singletonList(INVALID_TUPLE), ctx.asyncAssertFailure(cont)))));
    }

    @Test
    public void testNullValueIsAlwaysValid(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT 1 WHERE $1::INT4 IS NULL", ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.tuple().addInteger(null), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            async.complete();
        }))))));
    }

    @Test
    public void testStreamQueryError(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            stream.endHandler(v -> ctx.fail());
            AtomicInteger rowCount = new AtomicInteger();
            stream.exceptionHandler(err -> {
                ctx.assertEquals((Object)4, (Object)rowCount.getAndIncrement());
                async.complete();
            });
            stream.handler(tuple -> rowCount.incrementAndGet());
        }))));
    }

    @Test
    public void testCursorNoTx(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune", ctx.asyncAssertSuccess(ps -> {
            Cursor cursor = ps.cursor(Tuple.tuple());
            cursor.read(1, ctx.asyncAssertSuccess(rowSet -> cursor.read(1, ctx.asyncAssertFailure(err -> {
                PgException pgErr = (PgException)err;
                ctx.assertEquals((Object)"34000", (Object)pgErr.getCode());
            }))));
        }))));
    }

    @Test
    public void testCloseStatement(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT * FROM Fortune WHERE id=$1", ctx.asyncAssertSuccess(ps -> conn.query("SELECT * FROM pg_prepared_statements").execute(ctx.asyncAssertSuccess(res1 -> {
            boolean isStatementPrepared = false;
            for (Row row : res1) {
                String statement = row.getString("statement");
                if (!statement.equals("SELECT * FROM Fortune WHERE id=$1")) continue;
                isStatementPrepared = true;
            }
            if (!isStatementPrepared) {
                ctx.fail("Statement is not prepared");
            }
            ps.close(ctx.asyncAssertSuccess(v -> conn.query("SELECT * FROM pg_prepared_statements").execute(ctx.asyncAssertSuccess(res2 -> {
                for (Row row : res2) {
                    String statement = row.getString("statement");
                    if (!statement.equals("SELECT * FROM Fortune WHERE id=$1")) continue;
                    ctx.fail("Statement is not closed");
                }
                conn.close();
            }))));
        }))))));
    }

    @Test
    public void testInferDataTypeString42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, String.class, "WORLD", "WORLD");
    }

    @Test
    public void testInferDataTypeBoolean42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Boolean.class, true, "t");
    }

    @Test
    public void testInferDataTypeShort42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Short.class, (short)2, "2");
    }

    @Test
    public void testInferDataTypeInteger42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Integer.class, Integer.MAX_VALUE, "2147483647");
    }

    @Test
    public void testInferDataTypeLong42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Long.class, Long.MAX_VALUE, "9223372036854775807");
    }

    @Test
    public void testInferDataTypeFloat42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Float.class, Float.valueOf(0.0f), "0");
    }

    @Test
    public void testInferDataTypeDouble42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Double.class, 0.0, "0");
    }

    @Test
    public void testInferDataTypeLocalDate42P18(TestContext ctx) {
        LocalDate value = LocalDate.now();
        this.testInferDataType42P18(ctx, LocalDate.class, value, value.toString());
    }

    @Test
    public void testInferDataTypeLocalDateTime42P18(TestContext ctx) {
        LocalDateTime value = LocalDateTime.of(LocalDate.now(), LocalTime.NOON);
        String suffix = value.toLocalDate() + " " + value.toLocalTime().format(DateTimeFormatter.ISO_LOCAL_TIME);
        this.testInferDataType42P18(ctx, LocalDateTime.class, value, suffix, "{\"" + suffix + "\"}");
    }

    @Test
    public void testInferDataTypeOffsetDateTime42P18(TestContext ctx) {
        OffsetDateTime value = OffsetDateTime.of(LocalDateTime.of(LocalDate.now(), LocalTime.NOON), ZoneOffset.UTC);
        String suffix = value.toLocalDate() + " " + value.toLocalTime().format(DateTimeFormatter.ISO_LOCAL_TIME) + "+00";
        this.testInferDataType42P18(ctx, OffsetDateTime.class, value, suffix, "{\"" + suffix + "\"}");
    }

    @Test
    public void testInferDataTypeOffsetInterval42P18(TestContext ctx) {
        Interval value = Interval.of((int)1);
        this.testInferDataType42P18(ctx, Interval.class, value, "1 year", "{\"1 year\"}");
    }

    @Test
    public void testInferDataTypeBuffer42P18(TestContext ctx) {
        this.testInferDataType42P18(ctx, Buffer.class, Buffer.buffer((String)"WORLD"), "\\x574f524c44", "{\"\\\\x574f524c44\"}");
    }

    @Test
    public void testInferDataTypeUUID42P18(TestContext ctx) {
        UUID value = UUID.randomUUID();
        this.testInferDataType42P18(ctx, UUID.class, value, "" + value);
    }

    @Test
    public void testInferDataTypeJsonObject42P18(TestContext ctx) {
        JsonObject value = new JsonObject().put("foo", (Object)"bar");
        this.testInferDataType42P18(ctx, JsonObject.class, value, "" + value, "{\"{\\\"foo\\\":\\\"bar\\\"}\"}");
    }

    @Test
    public void testInferDataTypeJsonArray42P18(TestContext ctx) {
        JsonArray value = new JsonArray().add((Object)1).add((Object)"foo").add((Object)true);
        this.testInferDataType42P18(ctx, JsonArray.class, value, "" + value, "{\"[1,\\\"foo\\\",true]\"}");
    }

    @Test
    public void testInferDataTypePoint42P18(TestContext ctx) {
        Point value = new Point();
        this.testInferDataType42P18(ctx, Point.class, value, "(0,0)", "{\"(0,0)\"}");
    }

    @Test
    public void testInferDataTypeLine42P18(TestContext ctx) {
        Line value = new Line(1.0, 0.0, 0.0);
        this.testInferDataType42P18(ctx, Line.class, value, "{1,0,0}", "{\"{1,0,0}\"}");
    }

    @Test
    public void testInferDataTypeLineSegment42P18(TestContext ctx) {
        LineSegment value = new LineSegment();
        this.testInferDataType42P18(ctx, LineSegment.class, value, "[(0,0),(0,0)]", "{\"[(0,0),(0,0)]\"}");
    }

    @Test
    public void testInferDataTypeBox42P18(TestContext ctx) {
        Box value = new Box();
        this.testInferDataType42P18(ctx, Box.class, value, "(0,0),(0,0)");
    }

    @Test
    public void testInferDataTypePath42P18(TestContext ctx) {
        Path value = new Path().addPoint(new Point());
        this.testInferDataType42P18(ctx, Path.class, value, "((0,0))", "{\"((0,0))\"}");
    }

    @Test
    public void testInferDataTypePolygon42P18(TestContext ctx) {
        Polygon value = new Polygon().addPoint(new Point()).addPoint(new Point()).addPoint(new Point());
        this.testInferDataType42P18(ctx, Polygon.class, value, "((0,0),(0,0),(0,0))", "{\"((0,0),(0,0),(0,0))\"}");
    }

    @Test
    public void testInferDataTypeCircle42P18(TestContext ctx) {
        Circle value = new Circle();
        this.testInferDataType42P18(ctx, Circle.class, value, "<(0,0),0>", "{\"<(0,0),0>\"}");
    }

    private <T> void testInferDataType42P18(TestContext ctx, Class<T> type, T value, String suffix) {
        this.testInferDataType42P18(ctx, type, value, suffix, "{" + suffix + "}");
    }

    private <T> void testInferDataType42P18(TestContext ctx, Class<T> type, T value, String suffix1, String suffix2) {
        Object array = Array.newInstance(type, 1);
        Array.set(array, 0, value);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT CONCAT('HELLO ', $1)").execute(Tuple.of((Object)value)).map(result1 -> {
            Row row1 = (Row)result1.iterator().next();
            ctx.assertEquals((Object)("HELLO " + suffix1), (Object)row1.getString(0));
            return "";
        }).compose(v -> conn.preparedQuery("SELECT CONCAT('HELLO ', $1)").execute(Tuple.of((Object)array))).map(result2 -> {
            Row row2 = (Row)result2.iterator().next();
            String v = row2.getString(0);
            ctx.assertEquals((Object)("HELLO " + suffix2), (Object)row2.getString(0));
            return "";
        }).eventually(v -> conn.close())));
    }

    @Test
    public void testInferDataTypeLazy42P18(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT CONCAT('HELLO', $1)").compose(ps -> ps.query().execute(Tuple.of((Object)"__"))).map(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)"HELLO__", (Object)row.getString(0));
            return "";
        }).eventually(v -> conn.close())));
    }

    @Test
    public void testInferDataTypeFailure42P18(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT CONCAT('HELLO', $1)").execute(Tuple.of(null)).eventually(v -> conn.close()).onComplete(ctx.asyncAssertFailure())));
    }

    @Test
    public void testInferDataTypeLazyFailure42P18(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT CONCAT('HELLO', $1)").compose(ps -> ps.query().execute(Tuple.of(null))).eventually(v -> conn.close()).onComplete(ctx.asyncAssertFailure())));
    }

    @Test
    public void testInferDataTypeLazy42804(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT to_jsonb($1)").compose(ps -> ps.query().execute(Tuple.of((Object)"foo"))).map(result -> {
            ctx.assertEquals((Object)"foo", (Object)((Row)result.iterator().next()).getString(0));
            return "";
        }).eventually(v -> conn.close()).onComplete(ctx.asyncAssertSuccess())));
    }

    @Test
    public void testInferDataTypeLazy42P08(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE Fortune SET message=$2 WHERE id=$1 AND (Fortune.*) IS DISTINCT FROM ($1, $2)").compose(ps -> ps.query().execute(Tuple.of((Object)9, (Object)"Feature: A bug with seniority."))).eventually(v -> conn.close()).onComplete(ctx.asyncAssertSuccess())));
    }
}

