/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PreparedStatementTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class PreparedStatementCachedTest
extends PreparedStatementTestBase {
    @Override
    protected PgConnectOptions options() {
        return new PgConnectOptions(this.options).setCachePreparedStatements(true);
    }

    @Test
    public void testOneShotPreparedQueryCacheRefreshOnTableSchemaChange(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options(), (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM unstable WHERE id=$1").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            Tuple row1 = (Tuple)res1.iterator().next();
            ctx.assertEquals((Object)1, (Object)row1.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row1.getString(1));
            conn.query("ALTER TABLE unstable DROP COLUMN message").execute(ctx.asyncAssertSuccess(dropColumn -> conn.preparedQuery("SELECT * FROM unstable WHERE id=$1").execute(Tuple.of((Object)1), ctx.asyncAssertFailure(failure -> conn.preparedQuery("SELECT * FROM unstable WHERE id=$1").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)1, (Object)res2.size());
                Tuple row2 = (Tuple)res2.iterator().next();
                ctx.assertEquals((Object)1, (Object)row2.getInteger(0));
                ctx.assertEquals(null, (Object)row2.getString(1));
                conn.close();
                async.complete();
            }))))));
        }))));
    }

    @Test
    public void testMaxPreparedStatementEviction(TestContext ctx) {
        this.testPreparedStatements(ctx, this.options().setCachePreparedStatements(true).setPreparedStatementCacheMaxSize(16), 128, 16);
    }

    @Test
    public void testOneShotPreparedStatements(TestContext ctx) {
        this.testPreparedStatements(ctx, this.options().setCachePreparedStatements(false), 128, 0);
    }

    @Test
    public void testPreparedStatementCacheFiltering(TestContext ctx) {
        AtomicInteger count = new AtomicInteger();
        this.testPreparedStatements(ctx, this.options().setCachePreparedStatements(true).setPreparedStatementCacheSqlFilter(sql -> count.getAndIncrement() % 2 == 0), 128, 64);
    }

    private void testPreparedStatements(TestContext ctx, PgConnectOptions options, int num, int expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM pg_prepared_statements").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)0, (Object)res1.size());
            AtomicInteger count = new AtomicInteger(num);
            for (int i = 0; i < num; ++i) {
                int val = i;
                conn.preparedQuery("SELECT " + i).execute(Tuple.tuple(), ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)1, (Object)res2.size());
                    ctx.assertEquals((Object)val, (Object)((Row)res2.iterator().next()).getInteger(0));
                    if (count.decrementAndGet() == 0) {
                        ctx.assertEquals((Object)(num - 1), (Object)val);
                        conn.query("SELECT * FROM pg_prepared_statements").execute(ctx.asyncAssertSuccess(res3 -> {
                            ctx.assertEquals((Object)expected, (Object)res3.size());
                            conn.close(ctx.asyncAssertSuccess(v -> async.complete()));
                        }));
                    }
                }));
            }
        }))));
    }
}

