/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.junit.ContainerPgRule;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.ClassRule;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class PgTestBase {
    protected static final String ERRCODE_QUERY_CANCELED = "57014";
    @ClassRule
    public static ContainerPgRule rule = new ContainerPgRule();
    protected PgConnectOptions options;
    protected PoolOptions poolOptions;

    public void setup() throws Exception {
        this.options = rule.options();
        this.poolOptions = rule.poolOptions();
    }

    static void deleteFromTestTable(TestContext ctx, SqlClient client, Runnable completionHandler) {
        client.query("DELETE FROM Test").execute(ctx.asyncAssertSuccess(result -> completionHandler.run()));
    }

    static void insertIntoTestTable(TestContext ctx, SqlClient client, int amount, Runnable completionHandler) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 10; ++i) {
            client.query("INSERT INTO Test (id, val) VALUES (" + i + ", 'Whatever-" + i + "')").execute(ctx.asyncAssertSuccess(r1 -> {
                ctx.assertEquals((Object)1, (Object)r1.rowCount());
                if (count.incrementAndGet() == amount) {
                    completionHandler.run();
                }
            }));
        }
    }

    static boolean hasSqlstateCode(Throwable throwable, String code) {
        return throwable instanceof PgException && code.equals(((PgException)throwable).getCode());
    }
}

