/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.junit.ContainerPgRule;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class PgScramConnectionTest {
    @ClassRule
    public static ContainerPgRule rule = new ContainerPgRule();
    private Vertx vertx;
    private PgConnectOptions options;

    @Before
    public void setup() throws Exception {
        this.vertx = Vertx.vertx();
        this.options = rule.options();
    }

    private PgConnectOptions options() {
        return new PgConnectOptions(this.options);
    }

    @Test
    public void testSaslConnection(TestContext ctx) throws InterruptedException {
        Assume.assumeTrue((boolean)ContainerPgRule.isAtLeastPg10());
        Async async = ctx.async();
        PgConnectOptions options = new PgConnectOptions(this.options());
        options.setUser("saslscram");
        options.setPassword("saslscrampwd");
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)options, (Handler)ctx.asyncAssertSuccess(ar -> {
            ctx.assertNotNull(ar);
            async.complete();
        }));
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }
}

