/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnectionTestBase;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import org.junit.Test;

public class PgPooledConnectionTest
extends PgConnectionTestBase {
    private PgPool pool;

    public PgPooledConnectionTest() {
        this.connector = handler -> {
            if (this.pool == null) {
                this.pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(this.options), (PoolOptions)new PoolOptions().setMaxSize(1));
            }
            this.pool.getConnection(handler);
        };
    }

    @Override
    public void tearDown(TestContext ctx) {
        if (this.pool != null) {
            PgPool p = this.pool;
            this.pool = null;
            try {
                p.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        super.tearDown(ctx);
    }

    @Test
    public void testThatPoolReconnect(TestContext ctx) {
    }

    @Test
    public void testTransactionRollbackUnfinishedOnRecycle(TestContext ctx) {
        Async done = ctx.async(2);
        this.connector.accept(ctx.asyncAssertSuccess(conn1 -> PgPooledConnectionTest.deleteFromTestTable(ctx, (SqlClient)conn1, () -> {
            conn1.begin();
            conn1.query("INSERT INTO Test (id, val) VALUES (5, 'some-value')").execute(ctx.asyncAssertSuccess());
            conn1.query("SELECT txid_current()").execute(ctx.asyncAssertSuccess(result -> {
                Long txid1 = ((Row)result.iterator().next()).getLong(0);
                conn1.close();
                this.connector.accept(ctx.asyncAssertSuccess(conn2 -> {
                    conn2.query("SELECT id FROM Test WHERE id=5").execute(ctx.asyncAssertSuccess(result2 -> {
                        ctx.assertEquals((Object)0, (Object)result2.size());
                        done.countDown();
                    }));
                    conn2.query("SELECT txid_current()").execute(ctx.asyncAssertSuccess(result2 -> {
                        Long txid2 = ((Row)result.iterator().next()).getLong(0);
                        ctx.assertEquals((Object)txid1, (Object)txid2);
                        done.countDown();
                    }));
                }));
            }));
        })));
    }
}

