/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.impl.PgConnectionUriParser;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class PgConnectionUriParserTest {
    private String uri;
    private JsonObject actualParsedResult;
    private JsonObject expectedParsedResult;

    @Test
    public void testParsingUriSchemeDesignator() {
        this.uri = "postgresql://";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject();
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingAnotherUriSchemeDesignator() {
        this.uri = "postgres://";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject();
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUriSchemeDesignator() {
        this.uri = "posttgres://localhost";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUser() {
        this.uri = "postgres://user@";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPassword() {
        this.uri = "postgresql://user:secret@";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"secret");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHost() {
        this.uri = "postgresql://localhost";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv4Address() {
        this.uri = "postgresql://192.168.1.1";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"192.168.1.1");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv6Address() {
        this.uri = "postgresql://[2001:db8::1234]";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"2001:db8::1234");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPort() {
        this.uri = "postgresql://:1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingDbName() {
        this.uri = "postgres:///mydb";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingOneParameter() {
        this.uri = "postgresql://?user=other";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"other");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingParameters() {
        this.uri = "postgresql://?user=other&password=secret&port=1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"other").put("password", (Object)"secret").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHostAndParameters() {
        this.uri = "postgresql://localhost?user=other&password=secret";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other").put("password", (Object)"secret");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithoutPassword() {
        this.uri = "postgresql://user@";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingPasswordWithoutUser() {
        this.uri = "postgresql://:secret@";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingHostWithPort() {
        this.uri = "postgresql://localhost:1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPortAndDbName() {
        this.uri = "postgresql://:1234/mydb";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("port", (Object)1234).put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserAndParameters() {
        this.uri = "postgresql://user@?host=localhost&port=1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingDomainSocket() {
        this.uri = "postgresql://%2Fvar%2Flib%2Fpostgresql";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"/var/lib/postgresql");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingDomainSocketInParameter() {
        this.uri = "postgresql://?host=/var/lib/postgresql";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"/var/lib/postgresql");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUriWithOverridenParameters() {
        this.uri = "postgresql://localhost/mydb?host=myhost&port=1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"myhost").put("database", (Object)"mydb").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingFullUri() {
        this.uri = "postgresql://dbuser:secretpassword@database.server.com:3211/mydb";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"dbuser").put("password", (Object)"secretpassword").put("host", (Object)"database.server.com").put("port", (Object)3211).put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingParameterSslMode() {
        this.uri = "postgresql://?host=localhost&port=1234&sslmode=require";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234).put("sslMode", (Object)"REQUIRE");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingProperties() {
        this.uri = "postgresql://?application_name=myapp&search_path=myschema";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        HashMap<String, String> expectedProperties = new HashMap<String, String>();
        expectedProperties.put("application_name", "myapp");
        expectedProperties.put("search_path", "myschema");
        this.expectedParsedResult = new JsonObject().put("properties", expectedProperties);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri1() {
        this.uri = "postgresql://us@er@@";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri2() {
        this.uri = "postgresql://user/mydb//";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri3() {
        this.uri = "postgresql:///dbname/?host=localhost";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri4() {
        this.uri = "postgresql://user::1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri5() {
        this.uri = "postgresql://@:1234";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri6() {
        this.uri = "postgresql://:123:";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri7() {
        this.uri = "postgresql://@@/dbname?host";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidSslmode() {
        this.uri = "postgresql://?sslmode=invalidsslmode";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainExclamationMark() {
        this.uri = "postgresql://user!name:dd!dd@127.0.0.1:1234/dbname";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingSchemaContainExclamationMark() {
        this.uri = "postgresql://username:dddd@127.0.0.1:1234/!dbname";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainAsterisk() {
        this.uri = "postgresql://user*name:dd*dd@127.0.0.1:1234/dbname";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user*name").put("password", (Object)"dd*dd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSchemaContainAsterisk() {
        this.uri = "postgresql://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"username").put("password", (Object)"dddd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"*dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testPartialMatching() {
        this.uri = "not_pg://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = PgConnectionUriParser.parse((String)this.uri, (boolean)false);
        Assert.assertNull((Object)this.actualParsedResult);
    }
}

