/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgClientTestBase;
import io.vertx.pgclient.PgException;
import io.vertx.sqlclient.ProxyServer;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public abstract class PgConnectionTestBase
extends PgClientTestBase<SqlConnection> {
    @Test
    public void testDisconnectAbruptly(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create((Vertx)this.vertx, (int)this.options.getPort(), (String)this.options.getHost());
        proxy.proxyHandler(conn -> {
            this.vertx.setTimer(200L, id -> conn.close());
            conn.connect();
        });
        proxy.listen(8080, "localhost", ctx.asyncAssertSuccess(v1 -> {
            this.options.setPort(8080).setHost("localhost");
            this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.closeHandler(v2 -> async.complete())));
        }));
    }

    @Test
    public void testProtocolError(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create((Vertx)this.vertx, (int)this.options.getPort(), (String)this.options.getHost());
        CompletableFuture connected = new CompletableFuture();
        proxy.proxyHandler(conn -> {
            connected.thenAccept(v -> {
                System.out.println("send bogus");
                Buffer bogusMsg = Buffer.buffer();
                bogusMsg.appendByte((byte)82);
                bogusMsg.appendInt(0);
                bogusMsg.appendInt(1);
                bogusMsg.setInt(1, bogusMsg.length() - 1);
                conn.clientSocket().write((Object)bogusMsg);
            });
            conn.connect();
        });
        proxy.listen(8080, "localhost", ctx.asyncAssertSuccess(v1 -> {
            this.options.setPort(8080).setHost("localhost");
            this.connector.accept(ctx.asyncAssertSuccess(conn -> {
                AtomicInteger count = new AtomicInteger();
                conn.exceptionHandler(err -> {
                    ctx.assertEquals(err.getClass(), UnsupportedOperationException.class);
                    count.incrementAndGet();
                });
                conn.closeHandler(v -> {
                    ctx.assertEquals((Object)1, (Object)count.get());
                    async.complete();
                });
                connected.complete(null);
            }));
        }));
    }

    @Override
    @Test
    public void testTx(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("BEGIN").execute(ctx.asyncAssertSuccess(result1 -> {
            ctx.assertEquals((Object)0, (Object)result1.size());
            ctx.assertNotNull((Object)result1.iterator());
            conn.query("COMMIT").execute(ctx.asyncAssertSuccess(result2 -> {
                ctx.assertEquals((Object)0, (Object)result2.size());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testUpdateError(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO Fortune (id, message) VALUES (1, 'Duplicate')").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertEquals((Object)"23505", (Object)((PgException)err).getCode());
            conn.query("SELECT 1000").execute(ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1000, (Object)((Row)result.iterator().next()).getInteger(0));
                async.complete();
            }));
        }))));
    }

    @Test
    public void testBatchInsertError(TestContext ctx) throws Exception {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> {
            int id = PgConnectionTestBase.randomWorld();
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)id, (Object)3));
            conn.preparedQuery("INSERT INTO World (id, randomnumber) VALUES ($1, $2)").executeBatch(batch, ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)"23505", (Object)((PgException)err).getCode());
                conn.preparedQuery("SELECT 1000").execute(ctx.asyncAssertSuccess(result -> {
                    ctx.assertEquals((Object)1, (Object)result.size());
                    ctx.assertEquals((Object)1000, (Object)((Row)result.iterator().next()).getInteger(0));
                    async.complete();
                }));
            }));
        }));
    }

    @Test
    public void testCloseOnUndeploy(final TestContext ctx) {
        final Async done = ctx.async();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                PgConnectionTestBase.this.connector.accept(ctx.asyncAssertSuccess(conn -> {
                    conn.closeHandler(v -> done.complete());
                    startPromise.complete();
                }));
            }
        }, ctx.asyncAssertSuccess(id -> this.vertx.undeploy(id)));
    }

    @Test
    public void testTransactionCommit(TestContext ctx) {
        this.testTransactionCommit(ctx, Runnable::run);
    }

    @Test
    public void testTransactionCommitFromAnotherThread(TestContext ctx) {
        this.testTransactionCommit(ctx, t -> new Thread(t).start());
    }

    private void testTransactionCommit(TestContext ctx, Executor exec) {
        Async done = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> PgConnectionTestBase.deleteFromTestTable(ctx, (SqlClient)conn, () -> exec.execute(() -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            AtomicInteger u1 = new AtomicInteger();
            AtomicInteger u2 = new AtomicInteger();
            tx.completion().onComplete(ctx.asyncAssertSuccess(v -> {}));
            conn.query("INSERT INTO Test (id, val) VALUES (1, 'val-1')").execute(ctx.asyncAssertSuccess(res1 -> {
                u1.addAndGet(res1.rowCount());
                exec.execute(() -> conn.query("INSERT INTO Test (id, val) VALUES (2, 'val-2')").execute(ctx.asyncAssertSuccess(res2 -> {
                    u2.addAndGet(res2.rowCount());
                    exec.execute(() -> tx.commit(ctx.asyncAssertSuccess(v -> {
                        ctx.assertEquals((Object)1, (Object)u1.get());
                        ctx.assertEquals((Object)1, (Object)u2.get());
                        conn.query("SELECT id FROM Test WHERE id=1 OR id=2").execute(ctx.asyncAssertSuccess(result -> {
                            ctx.assertEquals((Object)2, (Object)result.size());
                            done.complete();
                        }));
                    })));
                })));
            }));
        }))))));
    }

    @Test
    public void testTransactionRollback(TestContext ctx) {
        this.testTransactionRollback(ctx, Runnable::run);
    }

    @Test
    public void testTransactionRollbackFromAnotherThread(TestContext ctx) {
        this.testTransactionRollback(ctx, t -> new Thread(t).start());
    }

    private void testTransactionRollback(TestContext ctx, Executor exec) {
        Async done = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> PgConnectionTestBase.deleteFromTestTable(ctx, (SqlClient)conn, () -> exec.execute(() -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            AtomicInteger u1 = new AtomicInteger();
            AtomicInteger u2 = new AtomicInteger();
            tx.completion().onComplete(ctx.asyncAssertFailure(err -> ctx.assertEquals((Object)TransactionRollbackException.INSTANCE, err)));
            conn.query("INSERT INTO Test (id, val) VALUES (1, 'val-1')").execute(ctx.asyncAssertSuccess(res1 -> {
                u1.addAndGet(res1.rowCount());
                exec.execute(() -> {});
                conn.query("INSERT INTO Test (id, val) VALUES (2, 'val-2')").execute(ctx.asyncAssertSuccess(res2 -> {
                    u2.addAndGet(res2.rowCount());
                    exec.execute(() -> tx.rollback(ctx.asyncAssertSuccess(v -> {
                        ctx.assertEquals((Object)1, (Object)u1.get());
                        ctx.assertEquals((Object)1, (Object)u2.get());
                        conn.query("SELECT id FROM Test WHERE id=1 OR id=2").execute(ctx.asyncAssertSuccess(result -> {
                            ctx.assertEquals((Object)0, (Object)result.size());
                            done.complete();
                        }));
                    })));
                }));
            }));
        }))))));
    }

    @Test
    public void testTransactionAbort(TestContext ctx) {
        Async done = ctx.async(2);
        this.connector.accept(ctx.asyncAssertSuccess(conn -> PgConnectionTestBase.deleteFromTestTable(ctx, (SqlClient)conn, () -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            tx.completion().onComplete(ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)TransactionRollbackException.INSTANCE, err);
                done.countDown();
            }));
            AtomicReference queryAfterFailed = new AtomicReference();
            AtomicReference commit = new AtomicReference();
            conn.query("INSERT INTO Test (id, val) VALUES (1, 'val-1')").execute(ar1 -> {});
            conn.query("INSERT INTO Test (id, val) VALUES (1, 'val-2')").execute(ar2 -> {
                ctx.assertNull(queryAfterFailed.get());
                ctx.assertNull(commit.get());
                ctx.assertTrue(ar2.failed());
            });
            conn.query("SELECT id FROM Test").execute(abc -> {
                queryAfterFailed.set(abc);
                conn.query("SELECT id FROM Test WHERE id=1").execute(ctx.asyncAssertSuccess(result -> {
                    ctx.assertEquals((Object)0, (Object)result.size());
                    done.countDown();
                }));
            });
            tx.commit(ar -> commit.set(ar));
        })))));
    }

    @Test
    public void testCloseConnectionFromDifferentContext(TestContext ctx) {
        Async done = ctx.async(1);
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
            ctx.assertEquals((Object)1, (Object)res.size());
            new Thread(() -> conn.close(v2 -> done.complete())).start();
        }))));
    }
}

