/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgConnectionTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.ArrayList;
import org.junit.Test;

public class PgConnectionTest
extends PgConnectionTestBase {
    public PgConnectionTest() {
        this.connector = handler -> PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, ar -> handler.handle((Object)ar.map(p -> p)));
    }

    @Test
    public void testSettingSchema(TestContext ctx) {
        this.options.addProperty("search_path", "myschema");
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("SHOW search_path;").execute(ctx.asyncAssertSuccess(pgRowSet -> ctx.assertEquals((Object)"myschema", (Object)((Row)pgRowSet.iterator().next()).getString("search_path"))))));
    }

    @Test
    public void testBatchUpdate(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> PgConnectionTest.deleteFromTestTable(ctx, (SqlClient)conn, () -> PgConnectionTest.insertIntoTestTable(ctx, (SqlClient)conn, 10, () -> conn.prepare("UPDATE Test SET val=$1 WHERE id=$2", ctx.asyncAssertSuccess(ps -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)"val0", (Object)0));
            batch.add(Tuple.of((Object)"val1", (Object)1));
            ps.query().executeBatch(batch, ctx.asyncAssertSuccess(result -> {
                for (int i = 0; i < 2; ++i) {
                    ctx.assertEquals((Object)1, (Object)result.rowCount());
                    result = result.next();
                }
                ctx.assertNull(result);
                ps.close(ctx.asyncAssertSuccess(v -> async.complete()));
            }));
        }))))));
    }

    @Test
    public void testQueueQueries(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num + 1);
        this.connector.accept(ctx.asyncAssertSuccess(conn -> {
            for (int i = 0; i < num; ++i) {
                conn.query("SELECT id, randomnumber from WORLD").execute(ar -> {
                    if (ar.succeeded()) {
                        SqlResult result = (SqlResult)ar.result();
                        ctx.assertEquals((Object)10000, (Object)result.size());
                    } else {
                        ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                    }
                    async.countDown();
                });
            }
            conn.closeHandler(v -> {
                ctx.assertEquals((Object)1, (Object)async.count());
                async.countDown();
            });
            conn.close();
        }));
    }

    @Test
    public void testCancelRequest(TestContext ctx) {
        Async async = ctx.async(2);
        this.connector.accept(ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT pg_sleep(10)").execute(ctx.asyncAssertFailure(error -> {
                ctx.assertTrue(PgConnectionTest.hasSqlstateCode(error, "57014"), error.getMessage());
                async.countDown();
            }));
            ((PgConnection)conn).cancelRequest(ctx.asyncAssertSuccess());
            conn.closeHandler(v -> {
                ctx.assertEquals((Object)1, (Object)async.count());
                async.countDown();
            });
            conn.close();
        }));
    }

    @Test
    public void testInflightCommandsFailWhenConnectionClosed(TestContext ctx) {
        this.connector.accept(ctx.asyncAssertSuccess(conn1 -> {
            conn1.query("SELECT pg_sleep(20)").execute(ctx.asyncAssertFailure(t -> ctx.assertEquals((Object)"Fail to read any response from the server, the underlying connection might get lost unexpectedly.", (Object)t.getMessage())));
            this.connector.accept(ctx.asyncAssertSuccess(conn2 -> conn2.query("SELECT * FROM pg_stat_activity WHERE state = 'active' AND query = 'SELECT pg_sleep(20)'").execute(ctx.asyncAssertSuccess(statRes -> {
                block0: {
                    RowIterator rowIterator = statRes.iterator();
                    if (!rowIterator.hasNext()) break block0;
                    Row row = (Row)rowIterator.next();
                    Integer id = row.getInteger("pid");
                    conn2.query(String.format("SELECT pg_terminate_backend(%d);", id)).execute(ctx.asyncAssertSuccess(v -> conn2.close()));
                }
            }))));
        }));
    }
}

