/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.HashMap;
import java.util.ServiceConfigurationError;
import org.junit.Assert;
import org.junit.Test;

public class PgConnectOptionsTest {
    private String connectionUri;
    private PgConnectOptions expectedConfiguration;
    private PgConnectOptions actualConfiguration;

    @Test
    public void testValidUri1() {
        this.connectionUri = "postgresql://";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions();
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri2() {
        this.connectionUri = "postgresql://myhost";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("myhost");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri3() {
        this.connectionUri = "postgresql://myhost:5433";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("myhost").setPort(5433);
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri4() {
        this.connectionUri = "postgresql://myhost/mydb";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("myhost").setDatabase("mydb");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri5() {
        this.connectionUri = "postgresql://user@myhost";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setUser("user").setHost("myhost");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri6() {
        this.connectionUri = "postgresql://user:secret@myhost";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setUser("user").setPassword("secret").setHost("myhost");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri7() {
        this.connectionUri = "postgresql://other@localhost/otherdb?port=5433&password=secret";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setUser("other").setPassword("secret").setHost("localhost").setPort(5433).setDatabase("otherdb");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri8() {
        this.connectionUri = "postgresql:///dbname?host=/var/lib/postgresql";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("/var/lib/postgresql").setDatabase("dbname");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri9() {
        this.connectionUri = "postgresql://%2Fvar%2Flib%2Fpostgresql/dbname";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("/var/lib/postgresql").setDatabase("dbname");
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri10() {
        this.connectionUri = "postgresql://user@myhost?sslmode=require";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        this.expectedConfiguration = new PgConnectOptions().setHost("myhost").setUser("user").setSslMode(SslMode.REQUIRE);
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri11() {
        this.connectionUri = "postgresql://user@myhost?application_name=myapp";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        HashMap<String, String> expectedProperties = new HashMap<String, String>();
        expectedProperties.put("application_name", "myapp");
        this.expectedConfiguration = new PgConnectOptions().setHost("myhost").setUser("user").setProperties(expectedProperties);
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test
    public void testValidUri12() {
        this.connectionUri = "postgresql://?fallback_application_name=myapp&search_path=myschema&options=--foo%3Dbar";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
        HashMap<String, String> expectedProperties = new HashMap<String, String>();
        expectedProperties.put("fallback_application_name", "myapp");
        expectedProperties.put("search_path", "myschema");
        expectedProperties.put("options", "--foo=bar");
        this.expectedConfiguration = new PgConnectOptions().setProperties(expectedProperties);
        PgConnectOptionsTest.assertEquals(this.expectedConfiguration, this.actualConfiguration);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri1() {
        this.connectionUri = "postgrsql://username";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri2() {
        this.connectionUri = "postgresql://username:password@loc//dbname";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri3() {
        this.connectionUri = "postgresql://user@:passowrd@localhost/dbname/qwer";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri4() {
        this.connectionUri = "postgresql://user:password@localhost:655355/dbname";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUri5() {
        this.connectionUri = "postgresql://user@localhost?port=1234&port";
        this.actualConfiguration = PgConnectOptions.fromUri((String)this.connectionUri);
    }

    @Test
    public void testMerge() {
        PgConnectOptions options = new PgConnectOptions();
        options.setUser("the-user");
        options.setPassword("the-password");
        options.setReconnectAttempts(3);
        JsonObject conf = new JsonObject();
        conf.put("database", (Object)"the-database");
        conf.put("host", (Object)"the-host");
        conf.put("port", (Object)1234);
        conf.put("port", (Object)1234);
        conf.put("pipeliningLimit", (Object)5);
        conf.put("reconnectInterval", (Object)10);
        options = options.merge(conf);
        Assert.assertEquals((Object)"the-user", (Object)options.getUser());
        Assert.assertEquals((Object)"the-password", (Object)options.getPassword());
        Assert.assertEquals((Object)"the-database", (Object)options.getDatabase());
        Assert.assertEquals((Object)"the-host", (Object)options.getHost());
        Assert.assertEquals((long)1234L, (long)options.getPort());
        Assert.assertEquals((long)5L, (long)options.getPipeliningLimit());
        Assert.assertEquals((long)10L, (long)options.getReconnectInterval());
        Assert.assertEquals((long)3L, (long)options.getReconnectAttempts());
    }

    @Test
    public void testGeneric() {
        PgConnectOptions options = (PgConnectOptions)SqlConnectOptions.fromUri((String)"postgresql://myhost:5433");
        Assert.assertEquals((Object)"myhost", (Object)options.getHost());
        Assert.assertEquals((long)5433L, (long)options.getPort());
        try {
            SqlConnectOptions.fromUri((String)"postgresql://username:password@loc//dbname");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SqlConnectOptions.fromUri((String)"whatever://myhost:5433");
            Assert.fail();
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
    }

    private static void assertEquals(PgConnectOptions expectedConfiguration, PgConnectOptions actualConfiguration) {
        Assert.assertEquals((Object)expectedConfiguration.toJson(), (Object)actualConfiguration.toJson());
    }
}

