/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgNotice;
import io.vertx.pgclient.PgTestBase;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NoticeTest
extends PgTestBase {
    Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testHandleNotice(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ArrayList notices = new ArrayList();
            conn.noticeHandler(notices::add);
            conn.query("SELECT raise_message('the message')").execute(ctx.asyncAssertSuccess(result1 -> {
                ctx.assertEquals((Object)1, (Object)notices.size());
                PgNotice notice = (PgNotice)notices.get(0);
                ctx.assertEquals((Object)"the message", (Object)notice.getMessage());
                ctx.assertEquals((Object)"NOTICE", (Object)notice.getSeverity());
                async.complete();
            }));
        }));
    }
}

