/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.netty.buffer.ByteBufUtil;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.ProxyServer;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.ConnectionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CloseConnectionTest
extends PgTestBase {
    protected Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testCloseConnection(TestContext ctx) {
        this.testCloseConnection(ctx, () -> PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options).onComplete(ctx.asyncAssertSuccess(conn -> conn.close(ctx.asyncAssertSuccess()))));
    }

    @Test
    public void testClosePooledConnection(TestContext ctx) {
        this.testCloseConnection(ctx, () -> {
            PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(1));
            pool.getConnection().onComplete(ctx.asyncAssertSuccess(conn -> conn.close(ctx.asyncAssertSuccess(v -> pool.close(ctx.asyncAssertSuccess())))));
        });
    }

    @Test
    public void testCloseNetSocket(TestContext ctx) {
        this.testCloseConnection(ctx, () -> {
            PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(1));
            ConnectionFactory factory = PgDriver.INSTANCE.createConnectionFactory(this.vertx, (SqlConnectOptions)this.options);
            pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
            pool.getConnection().onComplete(ctx.asyncAssertSuccess(conn -> conn.close(ctx.asyncAssertSuccess(v -> factory.close(Promise.promise())))));
        });
    }

    private void testCloseConnection(TestContext ctx, Runnable test) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create((Vertx)this.vertx, (int)this.options.getPort(), (String)this.options.getHost());
        proxy.proxyHandler(conn -> {
            Buffer data = Buffer.buffer();
            conn.clientHandler(buff -> {
                data.appendBuffer(buff);
                conn.serverSocket().write(buff);
            });
            conn.serverCloseHandler(v -> {
                ctx.assertTrue(data.length() > 5);
                String hex = ByteBufUtil.hexDump((byte[])data.slice(data.length() - 5, data.length()).getBytes());
                ctx.assertEquals((Object)"5800000004", (Object)hex);
                async.complete();
            });
            conn.connect();
        });
        proxy.listen(8080, "localhost", ctx.asyncAssertSuccess(v1 -> {
            this.options.setPort(8080).setHost("localhost");
            test.run();
        }));
    }
}

