/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.vertx.pgclient.impl.codec.Bind;
import io.vertx.pgclient.impl.codec.CloseConnectionCommandCodec;
import io.vertx.pgclient.impl.codec.ClosePortalCommandCodec;
import io.vertx.pgclient.impl.codec.CloseStatementCommandCodec;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.pgclient.impl.codec.Describe;
import io.vertx.pgclient.impl.codec.ExtendedQueryCommandCodec;
import io.vertx.pgclient.impl.codec.InitCommandCodec;
import io.vertx.pgclient.impl.codec.PasswordMessage;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PrepareStatementCommandCodec;
import io.vertx.pgclient.impl.codec.Query;
import io.vertx.pgclient.impl.codec.ScramClientFinalMessage;
import io.vertx.pgclient.impl.codec.ScramClientInitialMessage;
import io.vertx.pgclient.impl.codec.SimpleQueryCodec;
import io.vertx.pgclient.impl.codec.StartupMessage;
import io.vertx.pgclient.impl.util.Util;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.HexSequence;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Map;

final class PgEncoder
extends ChannelOutboundHandlerAdapter {
    private static final byte PASSWORD_MESSAGE = 112;
    private static final byte QUERY = 81;
    private static final byte TERMINATE = 88;
    private static final byte PARSE = 80;
    private static final byte BIND = 66;
    private static final byte DESCRIBE = 68;
    private static final byte EXECUTE = 69;
    private static final byte CLOSE = 67;
    private static final byte SYNC = 83;
    private final ArrayDeque<PgCommandCodec<?, ?>> inflight;
    private ChannelHandlerContext ctx;
    private ByteBuf out;
    private final HexSequence psSeq = new HexSequence();

    PgEncoder(ArrayDeque<PgCommandCodec<?, ?>> inflight) {
        this.inflight = inflight;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.out != null) {
            ByteBuf buff = this.out;
            this.out = null;
            buff.release();
        }
    }

    void write(CommandBase<?> cmd) {
        PgCommandCodec<?, ?> codec = this.wrap(cmd);
        codec.completionHandler = resp -> {
            PgCommandCodec<?, ?> c = this.inflight.poll();
            resp.cmd = c.cmd;
            this.ctx.fireChannelRead(resp);
        };
        codec.noticeHandler = arg_0 -> ((ChannelHandlerContext)this.ctx).fireChannelRead(arg_0);
        this.inflight.add(codec);
        codec.encode(this);
    }

    private PgCommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        if (cmd instanceof InitCommand) {
            return new InitCommandCodec((InitCommand)cmd);
        }
        if (cmd instanceof SimpleQueryCommand) {
            return new SimpleQueryCodec((SimpleQueryCommand)cmd);
        }
        if (cmd instanceof ExtendedQueryCommand) {
            return new ExtendedQueryCommandCodec((ExtendedQueryCommand)cmd);
        }
        if (cmd instanceof PrepareStatementCommand) {
            return new PrepareStatementCommandCodec((PrepareStatementCommand)cmd);
        }
        if (cmd instanceof CloseConnectionCommand) {
            return CloseConnectionCommandCodec.INSTANCE;
        }
        if (cmd instanceof CloseCursorCommand) {
            return new ClosePortalCommandCodec((CloseCursorCommand)cmd);
        }
        if (cmd instanceof CloseStatementCommand) {
            return new CloseStatementCommandCodec((CloseStatementCommand)cmd);
        }
        throw new AssertionError();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        this.flush();
    }

    void close() {
        ByteBuf buff;
        if (this.out != null) {
            buff = this.out;
            this.out = null;
        } else {
            buff = Unpooled.EMPTY_BUFFER;
        }
        this.ctx.writeAndFlush((Object)buff).addListener(v -> {
            Channel ch = this.channelHandlerContext().channel();
            if (ch instanceof SocketChannel) {
                SocketChannel channel = (SocketChannel)ch;
                channel.shutdownOutput();
            }
        });
    }

    void flush() {
        if (this.out != null) {
            ByteBuf buff = this.out;
            this.out = null;
            this.ctx.writeAndFlush((Object)buff, this.ctx.voidPromise());
        } else {
            this.ctx.flush();
        }
    }

    void writeTerminate() {
        this.ensureBuffer();
        this.out.writeByte(88);
        this.out.writeInt(4);
    }

    void writeSync() {
        this.ensureBuffer();
        this.out.writeByte(83);
        this.out.writeInt(4);
    }

    void writeClosePortal(String portal) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(67);
        this.out.writeInt(0);
        this.out.writeByte(80);
        Util.writeCStringUTF8(this.out, portal);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeClosePreparedStatement(byte[] statementName) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(67);
        this.out.writeInt(0);
        this.out.writeByte(83);
        this.out.writeBytes(statementName);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeStartupMessage(StartupMessage msg) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeInt(0);
        this.out.writeShort(3);
        this.out.writeShort(0);
        Util.writeCString(this.out, StartupMessage.BUFF_USER);
        Util.writeCStringUTF8(this.out, msg.username);
        Util.writeCString(this.out, StartupMessage.BUFF_DATABASE);
        Util.writeCStringUTF8(this.out, msg.database);
        for (Map.Entry<String, String> property : msg.properties.entrySet()) {
            Util.writeCString(this.out, property.getKey(), StandardCharsets.UTF_8);
            Util.writeCString(this.out, property.getValue(), StandardCharsets.UTF_8);
        }
        this.out.writeByte(0);
        this.out.setInt(pos, this.out.writerIndex() - pos);
    }

    void writePasswordMessage(PasswordMessage msg) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(112);
        this.out.writeInt(0);
        Util.writeCStringUTF8(this.out, msg.hash);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeScramClientInitialMessage(ScramClientInitialMessage msg) {
        this.ensureBuffer();
        this.out.writeByte(112);
        int totalLengthPosition = this.out.writerIndex();
        this.out.writeInt(0);
        Util.writeCStringUTF8(this.out, msg.mechanism);
        int msgPosition = this.out.writerIndex();
        this.out.writeInt(0);
        this.out.writeCharSequence((CharSequence)msg.message, StandardCharsets.UTF_8);
        this.out.setInt(msgPosition, this.out.writerIndex() - msgPosition - 4);
        this.out.setInt(totalLengthPosition, this.out.writerIndex() - totalLengthPosition);
    }

    void writeScramClientFinalMessage(ScramClientFinalMessage msg) {
        this.ensureBuffer();
        this.out.writeByte(112);
        int totalLengthPosition = this.out.writerIndex();
        this.out.writeInt(0);
        this.out.writeCharSequence((CharSequence)msg.message, StandardCharsets.UTF_8);
        this.out.setInt(totalLengthPosition, this.out.writerIndex() - totalLengthPosition);
    }

    void writeQuery(Query query) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(81);
        this.out.writeInt(0);
        Util.writeCStringUTF8(this.out, query.sql);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeDescribe(Describe describe) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(68);
        this.out.writeInt(0);
        if (describe.statement.length > 1) {
            this.out.writeByte(83);
            this.out.writeBytes(describe.statement);
        } else if (describe.portal != null) {
            this.out.writeByte(80);
            Util.writeCStringUTF8(this.out, describe.portal);
        } else {
            this.out.writeByte(83);
            Util.writeCStringUTF8(this.out, "");
        }
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeParse(String sql, byte[] statement, DataType[] parameterTypes) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(80);
        this.out.writeInt(0);
        this.out.writeBytes(statement);
        Util.writeCStringUTF8(this.out, sql);
        if (parameterTypes == null) {
            this.out.writeShort(0);
        } else {
            this.out.writeShort(parameterTypes.length);
            for (DataType parameterType : parameterTypes) {
                this.out.writeInt(parameterType.id);
            }
        }
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeExecute(String portal, int rowCount) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(69);
        this.out.writeInt(0);
        if (portal != null) {
            this.out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        this.out.writeByte(0);
        this.out.writeInt(rowCount);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    void writeBind(Bind bind, String portal, Tuple paramValues) {
        int c;
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(66);
        this.out.writeInt(0);
        if (portal != null) {
            this.out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        this.out.writeByte(0);
        this.out.writeBytes(bind.statement);
        int paramLen = paramValues.size();
        this.out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            this.out.writeShort(bind.paramTypes[c].supportsBinary ? 1 : 0);
        }
        this.out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            Object param = paramValues.getValue(c);
            if (param == null) {
                this.out.writeInt(-1);
                continue;
            }
            DataType dataType = bind.paramTypes[c];
            if (dataType.supportsBinary) {
                int idx = this.out.writerIndex();
                this.out.writeInt(0);
                DataTypeCodec.encodeBinary(dataType, param, this.out);
                this.out.setInt(idx, this.out.writerIndex() - idx - 4);
                continue;
            }
            DataTypeCodec.encodeText(dataType, param, this.out);
        }
        if (bind.resultColumns.length > 0) {
            this.out.writeShort(bind.resultColumns.length);
            for (PgColumnDesc resultColumn : bind.resultColumns) {
                this.out.writeShort(resultColumn.dataType.supportsBinary ? 1 : 0);
            }
        } else {
            this.out.writeShort(1);
            this.out.writeShort(1);
        }
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    private void ensureBuffer() {
        if (this.out == null) {
            this.out = this.ctx.alloc().ioBuffer();
        }
    }

    byte[] nextStatementName() {
        return this.psSeq.next();
    }

    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }
}

