/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.junit;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.ICommandLinePostProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.store.IArtifactStore;
import io.vertx.pgclient.PgConnectOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import ru.yandex.qatools.embed.postgresql.EmbeddedPostgres;
import ru.yandex.qatools.embed.postgresql.PostgresProcess;
import ru.yandex.qatools.embed.postgresql.distribution.Version;

@Deprecated
public class PgRule
extends ExternalResource {
    private static final String connectionUri = System.getProperty("connection.uri");
    private static EmbeddedPostgres postgres;
    private static final Map<String, Version> supportedPgVersions;
    private boolean domainSockets;
    private PgConnectOptions options;

    public static synchronized PgConnectOptions startPg() throws Exception {
        return PgRule.startPg(false);
    }

    public static synchronized PgConnectOptions startPg(boolean domainSockets) throws Exception {
        File sock;
        if (connectionUri != null && !connectionUri.isEmpty()) {
            return PgConnectOptions.fromUri((String)connectionUri);
        }
        if (postgres != null) {
            throw new IllegalStateException();
        }
        String a = System.getProperty("target.dir", "target");
        File targetDir = new File(a);
        if (!targetDir.exists() || !targetDir.isDirectory()) {
            throw new AssertionError((Object)"Cannot access target dir");
        }
        IRuntimeConfig config = EmbeddedPostgres.cachedRuntimeConfig((Path)targetDir.toPath());
        if (domainSockets) {
            sock = Files.createTempFile("pg_", ".sock", new FileAttribute[0]).toFile();
            Assert.assertTrue((boolean)sock.delete());
            Assert.assertTrue((boolean)sock.mkdir());
            sock.deleteOnExit();
            Files.setPosixFilePermissions(sock.toPath(), new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE)));
            config = PgRule.useDomainSocketRunTimeConfig(config, sock);
        } else {
            sock = null;
        }
        File dataDir = Files.createTempFile(targetDir.toPath(), "pg_", ".data", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)dataDir.delete());
        Assert.assertTrue((boolean)dataDir.mkdir());
        postgres = new EmbeddedPostgres((IVersion)PgRule.getPostgresVersion(), dataDir.getAbsolutePath());
        postgres.start(config, "localhost", 8081, "postgres", "postgres", "postgres", Collections.emptyList());
        File setupFile = PgRule.getTestResource("create-postgres.sql");
        ((PostgresProcess)postgres.getProcess().get()).importFromFile(setupFile);
        PgConnectOptions options = new PgConnectOptions();
        options.setHost(domainSockets ? sock.getAbsolutePath() : "localhost");
        options.setPort(8081);
        options.setUser("postgres");
        options.setPassword("postgres");
        options.setDatabase("postgres");
        if (!new File(dataDir, "postmaster.pid").exists()) {
            int amount;
            PostgresProcess process = (PostgresProcess)postgres.getProcess().get();
            Field f = AbstractProcess.class.getDeclaredField("process");
            f.setAccessible(true);
            ProcessControl ctrl = (ProcessControl)f.get(process);
            InputStreamReader reader = ctrl.getError();
            char[] buff = new char[1024];
            while ((amount = reader.read(buff)) != -1) {
                String s = new String(buff, 0, amount);
                System.out.println(s);
            }
        }
        return options;
    }

    public static synchronized void stopPg() {
        if (postgres != null) {
            try {
                postgres.stop();
            }
            finally {
                postgres = null;
            }
        }
    }

    private static File getTestResource(String name) throws Exception {
        FileInputStream in = new FileInputStream(new File("docker" + File.separator + "postgres" + File.separator + "resources" + File.separator + name));
        Path path = Files.createTempFile("pg-client", ".tmp", new FileAttribute[0]);
        Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        File file = path.toFile();
        file.deleteOnExit();
        return file;
    }

    private static IRuntimeConfig useDomainSocketRunTimeConfig(final IRuntimeConfig config, final File sock) throws Exception {
        return new RunTimeConfigBase(config){

            public ICommandLinePostProcessor getCommandLinePostProcessor() {
                ICommandLinePostProcessor commandLinePostProcessor = config.getCommandLinePostProcessor();
                return (distribution, args) -> {
                    ArrayList<String> result = commandLinePostProcessor.process(distribution, args);
                    if (((String)result.get(0)).endsWith("postgres")) {
                        result = new ArrayList<String>(result);
                        result.add("-k");
                        result.add(sock.getAbsolutePath());
                    }
                    return result;
                };
            }
        };
    }

    private static Version getPostgresVersion() {
        String specifiedVersion = System.getProperty("embedded.postgres.version");
        Version version = specifiedVersion == null || specifiedVersion.isEmpty() ? Version.V10_6 : supportedPgVersions.get(specifiedVersion);
        if (version == null) {
            throw new IllegalArgumentException("embedded postgres only supports the following versions: " + supportedPgVersions.keySet().toString() + "instead of " + specifiedVersion);
        }
        return version;
    }

    public PgConnectOptions options() {
        return new PgConnectOptions(this.options);
    }

    public PgRule domainSockets(boolean domainSockets) {
        this.domainSockets = domainSockets;
        return this;
    }

    protected void before() throws Throwable {
        this.options = PgRule.startPg(this.domainSockets);
    }

    protected void after() {
        if (this.options != null) {
            try {
                PgRule.stopPg();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    PgRule.getPostgresVersion();
                }
                catch (Exception e) {
                    throw new AssumptionViolatedException(e.getMessage());
                }
                PgRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    PgRule.this.after();
                }
            }
        };
    }

    static {
        supportedPgVersions = new HashMap<String, Version>();
        supportedPgVersions.put("9.6", Version.V9_6_11);
        supportedPgVersions.put("10.6", Version.V10_6);
    }

    private static abstract class RunTimeConfigBase
    implements IRuntimeConfig {
        private final IRuntimeConfig config;

        private RunTimeConfigBase(IRuntimeConfig config) {
            this.config = config;
        }

        public ProcessOutput getProcessOutput() {
            return this.config.getProcessOutput();
        }

        public IArtifactStore getArtifactStore() {
            return this.config.getArtifactStore();
        }

        public boolean isDaemonProcess() {
            return this.config.isDaemonProcess();
        }
    }
}

