/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.DataTypeTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;

public abstract class SimpleQueryDataTypeCodecTestBase
extends DataTypeTestBase {
    @Override
    public void setup() throws Exception {
        super.setup();
        this.options.setCachePreparedStatements(false);
    }

    protected <T> void testDecodeGeneric(TestContext ctx, String data, String dataType, String columnName, Class<T> type, T expected) {
        this.testDecodeGeneric(ctx, data, dataType, columnName, ColumnChecker.getByIndex(type), ColumnChecker.getByName(type), expected);
    }

    protected <T> void testDecodeGeneric(TestContext ctx, String data, String dataType, String columnName, ColumnChecker.SerializableBiFunction<Tuple, Integer, T> byIndexGetter, ColumnChecker.SerializableBiFunction<Row, String, T> byNameGetter, T expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '" + data + "' :: " + dataType + " \"" + columnName + "\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, expected).returns(byIndexGetter, byNameGetter, expected).forRow(row);
            async.complete();
        }))));
    }

    protected void testDecodeGenericArray(TestContext ctx, String arrayData, String columnName, Class<?> type, Object[] expected) {
        Class<?> clazz = type;
        ColumnChecker.SerializableBiFunction byIndex = ColumnChecker.getValuesByIndex(clazz);
        ColumnChecker.SerializableBiFunction byName = ColumnChecker.getValuesByName(clazz);
        this.testDecodeGenericArray(ctx, arrayData, columnName, (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)byIndex, (ColumnChecker.SerializableBiFunction<Row, String, Object>)byName, expected);
    }

    protected void testDecodeGenericArray(TestContext ctx, String arrayData, String columnName, ColumnChecker.SerializableBiFunction<Tuple, Integer, Object> byIndexGetter, ColumnChecker.SerializableBiFunction<Row, String, Object> byNameGetter, Object ... expected) {
        this.testDecodeGenericArray(ctx, arrayData, columnName, ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, expected).returns(byIndexGetter, byNameGetter, expected));
    }

    protected void testDecodeGenericArray(TestContext ctx, String arrayData, String columnName, ColumnChecker checker) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(res -> conn.query("SELECT " + arrayData + " \"" + columnName + "\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.forRow(row);
            async.complete();
        }))))));
    }

    protected <T> void testDecodeXXXArray(TestContext ctx, String columnName, String tableName, ColumnChecker.SerializableBiFunction<Tuple, Integer, Object> byIndexGetter, ColumnChecker.SerializableBiFunction<Row, String, Object> byNameGetter, Object ... expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(res -> conn.query("SELECT \"" + columnName + "\" FROM \"" + tableName + "\" WHERE \"id\" = 1").execute(ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, expected).returns(byIndexGetter, byNameGetter, expected).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }
}

