/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.DataTypeTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.lang.reflect.Array;
import java.math.BigInteger;
import org.junit.Test;

public class PreparedStatementParamCoercionTest
extends DataTypeTestBase {
    private static final Object[] VALUES_TO_COERCE = new Object[]{(byte)5, (short)5, 5, 5L, Float.valueOf(5.0f), 5.0, BigInteger.valueOf(5L), Numeric.create((Number)5)};
    private static final String[] SQL_TYPES_TO_COERCE_TO = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL", "NUMERIC", "REAL", "DOUBLE PRECISION"};

    @Test
    public void testCoerceSingleParam(TestContext ctx) {
        Async async = ctx.async(VALUES_TO_COERCE.length * SQL_TYPES_TO_COERCE_TO.length);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            for (String sqlType : SQL_TYPES_TO_COERCE_TO) {
                for (Object value : VALUES_TO_COERCE) {
                    this.assertCoerceParam((PgConnection)conn, ctx, "SELECT 1 \"result\" WHERE $1::" + sqlType + "=5", value, () -> ((Async)async).countDown());
                }
            }
        }));
    }

    @Test
    public void testCoerceArrayParam(TestContext ctx) {
        Async async = ctx.async(VALUES_TO_COERCE.length * SQL_TYPES_TO_COERCE_TO.length);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            for (String sqlType : SQL_TYPES_TO_COERCE_TO) {
                for (Object value : VALUES_TO_COERCE) {
                    Object array = Array.newInstance(value.getClass(), 1);
                    Array.set(array, 0, value);
                    this.assertCoerceParam((PgConnection)conn, ctx, "SELECT 1 \"result\" WHERE ($1::" + sqlType + "[])=ARRAY[5::" + sqlType + "]", array, () -> ((Async)async).countDown());
                }
            }
        }));
    }

    private void assertCoerceParam(PgConnection conn, TestContext ctx, String query, Object value, Runnable cont) {
        conn.preparedQuery(query).execute(Tuple.of((Object)value), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)((Row)result.iterator().next()).getInteger(0));
            cont.run();
        }));
    }

    @Test
    public void testCoercionError(TestContext ctx) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1::UUID", ctx.asyncAssertSuccess(pq -> pq.query().execute(Tuple.of((Object)"not-an-uuid"), ctx.asyncAssertFailure(res -> {}))))));
    }
}

