/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.SimpleQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import org.junit.Test;

public class NumericTypesSimpleCodecTest
extends SimpleQueryDataTypeCodecTestBase {
    @Test
    public void testInt2(TestContext ctx) {
        this.testNumber(ctx, new Number[]{(short)Short.MAX_VALUE, (short)-1}, "INT2");
    }

    @Test
    public void testInt4(TestContext ctx) {
        this.testNumber(ctx, new Number[]{Integer.MAX_VALUE, -1}, "INT4");
    }

    @Test
    public void testInt8(TestContext ctx) {
        this.testNumber(ctx, new Number[]{Long.MAX_VALUE, -1L}, "INT8");
    }

    @Test
    public void testFloat4(TestContext ctx) {
        this.testNumber(ctx, new Number[]{Float.valueOf(Float.MAX_VALUE), Float.valueOf(-1.0f)}, "FLOAT4");
    }

    @Test
    public void testFloat8(TestContext ctx) {
        this.testNumber(ctx, new Number[]{Double.MAX_VALUE, -1.0}, "FLOAT8");
    }

    @Test
    public void testSerial2(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT \"SmallSerial\" FROM \"NumericDataType\" WHERE \"id\" = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"SmallSerial").returns(Tuple::getValue, Row::getValue, (Object)1).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testSerial4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT \"Serial\" FROM \"NumericDataType\" WHERE \"id\" = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Serial").returns(Tuple::getValue, Row::getValue, (Object)1).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testSerial8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT \"BigSerial\" FROM \"NumericDataType\" WHERE \"id\" = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"BigSerial").returns(Tuple::getValue, Row::getValue, (Object)1L).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testNumeric(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 919.999999999999999999999999999999999999::NUMERIC \"Numeric\", 'NaN'::NUMERIC \"NaN\"").execute(ctx.asyncAssertSuccess(result -> {
            Numeric numeric = Numeric.parse((String)"919.999999999999999999999999999999999999");
            Numeric nan = Numeric.parse((String)"NaN");
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Numeric").returns(Tuple::getValue, Row::getValue, (Object)numeric).returns(Tuple::getShort, Row::getShort, (Object)919).returns(Tuple::getInteger, Row::getInteger, (Object)919).returns(Tuple::getLong, Row::getLong, (Object)919L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(920.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)920.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)numeric.bigDecimalValue()).returns(Numeric.class, (Object)numeric).forRow(row);
            ColumnChecker.checkColumn((int)1, (String)"NaN").returns(Tuple::getValue, Row::getValue, (Object)nan).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)0).returns(Tuple::getLong, Row::getLong, (Object)0L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(Float.NaN)).returns(Tuple::getDouble, Row::getDouble, (Object)Double.NaN).fails(Tuple::getBigDecimal, Row::getBigDecimal).returns(Numeric.class, (Object)nan).forRow(row);
            async.complete();
        }))));
    }

    private void testNumber(TestContext ctx, Number[] values, String type) {
        Async async = ctx.async(values.length);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            for (Number value : values) {
                conn.query("SELECT " + value + "::" + type + " \"col\"").execute(ctx.asyncAssertSuccess(result -> {
                    ctx.assertEquals((Object)1, (Object)result.size());
                    Row row = (Row)result.iterator().next();
                    ColumnChecker.checkColumn((int)0, (String)"col").returns(Tuple::getValue, Row::getValue, (Object)value).returns(Tuple::getShort, Row::getShort, (Object)value.shortValue()).returns(Tuple::getInteger, Row::getInteger, (Object)value.intValue()).returns(Tuple::getLong, Row::getLong, (Object)value.longValue()).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(value.floatValue())).returns(Tuple::getDouble, Row::getDouble, (Object)value.doubleValue()).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal("" + value)).returns(Numeric.class, (Object)Numeric.parse((String)("" + value))).forRow(row);
                    async.countDown();
                }));
            }
        }));
    }

    @Test
    public void testDecodeINT2Array(TestContext ctx) {
        this.testDecodeNumberArray(ctx, "ARRAY [1 :: INT2]", "Short", (short)1);
    }

    @Test
    public void testDecodeINT4Array(TestContext ctx) {
        this.testDecodeNumberArray(ctx, "ARRAY [2 :: INT4]", "Integer", 2);
    }

    @Test
    public void testDecodeINT8Array(TestContext ctx) {
        this.testDecodeNumberArray(ctx, "ARRAY [3 :: INT8]", "Long", 3L);
    }

    @Test
    public void testDecodeFLOAT4Array(TestContext ctx) {
        this.testDecodeNumberArray(ctx, "ARRAY [4.1 :: FLOAT4]", "Float", Float.valueOf(4.1f));
    }

    @Test
    public void testDecodeFLOAT8Array(TestContext ctx) {
        this.testDecodeNumberArray(ctx, "ARRAY [5.2 :: FLOAT8]", "Double", 5.2);
    }

    protected void testDecodeNumberArray(TestContext ctx, String arrayData, String columnName, Number ... value) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT " + arrayData + " \"" + columnName + "\"").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, (Object[])value).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, (Object[])new Short[]{value[0].shortValue()}).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, (Object[])new Integer[]{value[0].intValue()}).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, (Object[])new Long[]{value[0].longValue()}).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, (Object[])new Float[]{Float.valueOf(value[0].floatValue())}).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, (Object[])new Double[]{value[0].doubleValue()}).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, (Object[])new Numeric[]{Numeric.create((Number)value[0])}).forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testDecodeEmptyArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '{}'::bigint[] \"array\", 1 \"Extra\"").execute(ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"array").returns(Tuple::getValue, Row::getValue, (Object[])new Long[0]).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, (Object[])new Short[0]).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, (Object[])new Integer[0]).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, (Object[])new Long[0]).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, (Object[])new Float[0]).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, (Object[])new Double[0]).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, (Object[])new Numeric[0]).forRow((Row)result.iterator().next());
            async.complete();
        }))));
    }
}

