/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import org.junit.Test;

public class NumericTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeInt2(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: INT2 \"Short\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addShort(Short.valueOf((short)Short.MAX_VALUE)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Short").returns(Tuple::getValue, Row::getValue, (Object)Short.MAX_VALUE).returns(Tuple::getShort, Row::getShort, (Object)Short.MAX_VALUE).returns(Tuple::getInteger, Row::getInteger, (Object)Short.MAX_VALUE).returns(Tuple::getLong, Row::getLong, (Object)32767L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(32767.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)32767.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Short.MAX_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Short.MAX_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeInt2(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Short\" = $1 WHERE \"id\" = $2 RETURNING \"Short\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)Short.MIN_VALUE, (Object)2), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Short").returns(Tuple::getValue, Row::getValue, (Object)Short.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)Short.MIN_VALUE).returns(Tuple::getInteger, Row::getInteger, (Object)Short.MIN_VALUE).returns(Tuple::getLong, Row::getLong, (Object)-32768L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-32768.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)-32768.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Short.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Short.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeInt4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: INT4 \"Integer\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(Integer.MAX_VALUE)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Integer").returns(Tuple::getValue, Row::getValue, (Object)Integer.MAX_VALUE).returns(Tuple::getShort, Row::getShort, (Object)-1).returns(Tuple::getInteger, Row::getInteger, (Object)Integer.MAX_VALUE).returns(Tuple::getLong, Row::getLong, (Object)Integer.MAX_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(2.1474836E9f)).returns(Tuple::getDouble, Row::getDouble, (Object)2.147483647E9).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Integer.MAX_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Integer.MAX_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeInt4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Integer\" = $1 WHERE \"id\" = $2 RETURNING \"Integer\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(Integer.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Integer").returns(Tuple::getValue, Row::getValue, (Object)Integer.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)Integer.MIN_VALUE).returns(Tuple::getLong, Row::getLong, (Object)Integer.MIN_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-2.1474836E9f)).returns(Tuple::getDouble, Row::getDouble, (Object)-2.147483648E9).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Integer.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Integer.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeInt8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: INT8 \"Long\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addLong(Long.valueOf(Long.MAX_VALUE)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Long").returns(Tuple::getValue, Row::getValue, (Object)Long.MAX_VALUE).returns(Tuple::getShort, Row::getShort, (Object)-1).returns(Tuple::getInteger, Row::getInteger, (Object)-1).returns(Tuple::getLong, Row::getLong, (Object)Long.MAX_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(9.223372E18f)).returns(Tuple::getDouble, Row::getDouble, (Object)9.223372036854776E18).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Long.MAX_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Long.MAX_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeInt8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Long\" = $1 WHERE \"id\" = $2 RETURNING \"Long\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addLong(Long.valueOf(Long.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Long").returns(Tuple::getValue, Row::getValue, (Object)Long.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)0).returns(Tuple::getLong, Row::getLong, (Object)Long.MIN_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-9.223372E18f)).returns(Tuple::getDouble, Row::getDouble, (Object)-9.223372036854776E18).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Long.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Long.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeFloat4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: FLOAT4\"Float\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addFloat(Float.valueOf(Float.MAX_VALUE)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Float").returns(Tuple::getValue, Row::getValue, (Object)Float.valueOf(Float.MAX_VALUE)).returns(Tuple::getShort, Row::getShort, (Object)-1).returns(Tuple::getInteger, Row::getInteger, (Object)Integer.MAX_VALUE).returns(Tuple::getLong, Row::getLong, (Object)Long.MAX_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(Float.MAX_VALUE)).returns(Tuple::getDouble, Row::getDouble, (Object)3.4028234663852886E38).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal("3.4028235E38")).returns(Numeric.class, (Object)Numeric.parse((String)"3.4028235E38")).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeFloat4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Float\" = $1 WHERE \"id\" = $2 RETURNING \"Float\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addFloat(Float.valueOf(Float.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Float").returns(Tuple::getValue, Row::getValue, (Object)Float.valueOf(Float.MIN_VALUE)).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)0).returns(Tuple::getLong, Row::getLong, (Object)0L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(Float.MIN_VALUE)).returns(Tuple::getDouble, Row::getDouble, (Object)Float.MIN_VALUE).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal("1.4E-45")).returns(Numeric.class, (Object)Numeric.parse((String)"1.4E-45")).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeFloat8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: FLOAT8\"Double\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addDouble(Double.valueOf(Double.MAX_VALUE)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Double").returns(Tuple::getValue, Row::getValue, (Object)Double.MAX_VALUE).returns(Tuple::getShort, Row::getShort, (Object)-1).returns(Tuple::getInteger, Row::getInteger, (Object)Integer.MAX_VALUE).returns(Tuple::getLong, Row::getLong, (Object)Long.MAX_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(Float.POSITIVE_INFINITY)).returns(Tuple::getDouble, Row::getDouble, (Object)Double.MAX_VALUE).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal("1.7976931348623157E308")).returns(Numeric.class, (Object)Numeric.parse((String)"1.7976931348623157E308")).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeFloat8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Double\" = $1 WHERE \"id\" = $2 RETURNING \"Double\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addDouble(Double.valueOf(Double.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Double").returns(Tuple::getValue, Row::getValue, (Object)Double.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)0).returns(Tuple::getLong, Row::getLong, (Object)0L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(0.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)Double.MIN_VALUE).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal("4.9E-324")).returns(Numeric.class, (Object)Numeric.parse((String)"4.9E-324")).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeSerial2(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"SmallSerial\" FROM \"NumericDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"SmallSerial").returns(Tuple::getValue, Row::getValue, (Object)1).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeSerial2(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"SmallSerial\" = $1 WHERE \"id\" = $2 RETURNING \"SmallSerial\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.of((Object)Short.MIN_VALUE, (Object)2), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"SmallSerial").returns(Tuple::getValue, Row::getValue, (Object)Short.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)Short.MIN_VALUE).returns(Tuple::getInteger, Row::getInteger, (Object)Short.MIN_VALUE).returns(Tuple::getLong, Row::getLong, (Object)-32768L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-32768.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)-32768.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Short.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Short.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeSerial4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Serial\" FROM \"NumericDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Serial").returns(Tuple::getValue, Row::getValue, (Object)1).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeSerial4(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"Serial\" = $1 WHERE \"id\" = $2 RETURNING \"Serial\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(Integer.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Serial").returns(Tuple::getValue, Row::getValue, (Object)Integer.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)Integer.MIN_VALUE).returns(Tuple::getLong, Row::getLong, (Object)Integer.MIN_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-2.1474836E9f)).returns(Tuple::getDouble, Row::getDouble, (Object)-2.147483648E9).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Integer.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Integer.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeSerial8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"BigSerial\" FROM \"NumericDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"BigSerial").returns(Tuple::getValue, Row::getValue, (Object)1L).returns(Tuple::getShort, Row::getShort, (Object)1).returns(Tuple::getInteger, Row::getInteger, (Object)1).returns(Tuple::getLong, Row::getLong, (Object)1L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(1.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)1.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(1)).returns(Numeric.class, (Object)Numeric.create((Number)1)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeSerial8(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"NumericDataType\" SET \"BigSerial\" = $1 WHERE \"id\" = $2 RETURNING \"BigSerial\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addLong(Long.valueOf(Long.MIN_VALUE)).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"BigSerial").returns(Tuple::getValue, Row::getValue, (Object)Long.MIN_VALUE).returns(Tuple::getShort, Row::getShort, (Object)0).returns(Tuple::getInteger, Row::getInteger, (Object)0).returns(Tuple::getLong, Row::getLong, (Object)Long.MIN_VALUE).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(-9.223372E18f)).returns(Tuple::getDouble, Row::getDouble, (Object)-9.223372036854776E18).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(Long.MIN_VALUE)).returns(Numeric.class, (Object)Numeric.create((Number)Long.MIN_VALUE)).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testShortArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT c FROM (VALUES ($1 :: INT2[])) AS t (c)", new Short[][]{{(short)0, (short)-10, null, (short)Short.MAX_VALUE}}, Tuple::getArrayOfShorts);
    }

    @Test
    public void testIntegerArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT c FROM (VALUES ($1 :: INT4[])) AS t (c)", new Integer[][]{{0, -10, null, Integer.MAX_VALUE}}, Tuple::getArrayOfIntegers);
    }

    @Test
    public void testLongArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT c FROM (VALUES ($1 :: INT8[])) AS t (c)", new Long[][]{{0L, -10L, null, Long.MAX_VALUE}}, Tuple::getArrayOfLongs);
    }

    @Test
    public void testFloatArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT c FROM (VALUES ($1 :: FLOAT4[])) AS t (c)", new Float[][]{{Float.valueOf(0.0f), Float.valueOf(-10.0f), Float.valueOf(Float.MAX_VALUE)}}, Tuple::getArrayOfFloats);
    }

    @Test
    public void testDecodeShortArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Short\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Short").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new short[]{1})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{1})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{1})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{1L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{1.0f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{1.0})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)1)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeShortArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Short\" = $1  WHERE \"id\" = $2 RETURNING \"Short\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfShort(new Short[]{(short)2, (short)3, (short)4}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Short").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new short[]{2, 3, 4})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{2, 3, 4})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{2, 3, 4})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{2L, 3L, 4L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{2.0f, 3.0f, 4.0f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{2.0, 3.0, 4.0})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)2), Numeric.create((Number)3), Numeric.create((Number)4)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeIntArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Integer\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Integer").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new int[]{2})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{2})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{2})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{2L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{2.0f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{2.0})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)2)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeIntArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Integer\" = $1  WHERE \"id\" = $2 RETURNING \"Integer\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfInteger(new Integer[]{3, 4, 5, 6}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Integer").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new int[]{3, 4, 5, 6})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{3, 4, 5, 6})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{3, 4, 5, 6})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{3L, 4L, 5L, 6L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{3.0f, 4.0f, 5.0f, 6.0f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{3.0, 4.0, 5.0, 6.0})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)3), Numeric.create((Number)4), Numeric.create((Number)5), Numeric.create((Number)6)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeLongArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Long\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Long").returns(Tuple::getValue, Row::getValue, (Object[])new Long[]{3L}).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, (Object[])new Short[]{(short)3}).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, (Object[])new Integer[]{3}).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, (Object[])new Long[]{3L}).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, (Object[])new Float[]{Float.valueOf(3.0f)}).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, (Object[])new Double[]{3.0}).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)3)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeLongArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Long\" = $1  WHERE \"id\" = $2 RETURNING \"Long\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfLong(new Long[]{4L, 5L, 6L, 7L, 8L}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Long").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new long[]{4L, 5L, 6L, 7L, 8L})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{4, 5, 6, 7, 8})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{4, 5, 6, 7, 8})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{4L, 5L, 6L, 7L, 8L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{4.0f, 5.0f, 6.0f, 7.0f, 8.0f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{4.0, 5.0, 6.0, 7.0, 8.0})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)4), Numeric.create((Number)5), Numeric.create((Number)6), Numeric.create((Number)7), Numeric.create((Number)8)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeFloatArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Float\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Float").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new float[]{4.1f})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{4})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{4})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{4L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{4.1f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{4.1f})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)Float.valueOf(4.1f))})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeFloatArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Float\" = $1  WHERE \"id\" = $2 RETURNING \"Float\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfFloat(new Float[]{Float.valueOf(5.2f), Float.valueOf(5.3f), Float.valueOf(5.4f)}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Float").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new float[]{5.2f, 5.3f, 5.4f})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{5, 5, 5})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{5, 5, 5})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{5L, 5L, 5L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{5.2f, 5.3f, 5.4f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{5.2f, 5.3f, 5.4f})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)Float.valueOf(5.2f)), Numeric.create((Number)Float.valueOf(5.3f)), Numeric.create((Number)Float.valueOf(5.4f))})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeDoubleArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Double\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Double").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new double[]{5.2})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{5})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{5})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{5L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{5.2f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{5.2})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)5.2)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeDoubleArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Double\" = $1  WHERE \"id\" = $2 RETURNING \"Double\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfDouble(new Double[]{6.3}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Double").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new double[]{6.3})).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[]{6})).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[]{6})).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[]{6L})).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[]{6.3f})).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[]{6.3})).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[]{Numeric.create((Number)6.3)})).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeEmptyArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Double\" = $1  WHERE \"id\" = $2 RETURNING \"Double\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfDouble(new Double[0]).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Double").returns(Tuple::getValue, Row::getValue, ColumnChecker.toObjectArray((Object)new double[0])).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, ColumnChecker.toObjectArray((Object)new short[0])).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, ColumnChecker.toObjectArray((Object)new int[0])).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, ColumnChecker.toObjectArray((Object)new long[0])).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, ColumnChecker.toObjectArray((Object)new float[0])).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, ColumnChecker.toObjectArray((Object)new double[0])).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, ColumnChecker.toObjectArray((Object)new Numeric[0])).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeNumericArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Numeric\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            Object[] expected = new Numeric[]{Numeric.create((Number)0), Numeric.create((Number)1), Numeric.create((Number)2), Numeric.create((Number)3)};
            ColumnChecker.checkColumn((int)0, (String)"Numeric").returns(Tuple::getValue, Row::getValue, expected).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, (Object[])new Short[]{(short)0, (short)1, (short)2, (short)3}).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, (Object[])new Integer[]{0, 1, 2, 3}).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, (Object[])new Long[]{0L, 1L, 2L, 3L}).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, (Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, (Object[])new Double[]{0.0, 1.0, 2.0, 3.0}).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, (Object[])new Numeric[]{Numeric.create((Number)0), Numeric.create((Number)1), Numeric.create((Number)2), Numeric.create((Number)3)}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeNumericArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Numeric\" = $1  WHERE \"id\" = $2 RETURNING \"Numeric\"", ctx.asyncAssertSuccess(p -> {
            Numeric[] expected = new Numeric[]{Numeric.create((Number)0), Numeric.create((Number)10000)};
            p.query().execute(Tuple.tuple().addValue((Object)expected).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"Numeric").returns(Tuple::getValue, Row::getValue, (Object[])expected).returns(Tuple::getArrayOfShorts, Row::getArrayOfShorts, (Object[])new Short[]{expected[0].shortValue(), expected[1].shortValue()}).returns(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers, (Object[])new Integer[]{expected[0].intValue(), expected[1].intValue()}).returns(Tuple::getArrayOfLongs, Row::getArrayOfLongs, (Object[])new Long[]{expected[0].longValue(), expected[1].longValue()}).returns(Tuple::getArrayOfFloats, Row::getArrayOfFloats, (Object[])new Float[]{Float.valueOf(expected[0].floatValue()), Float.valueOf(expected[1].floatValue())}).returns(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles, (Object[])new Double[]{expected[0].doubleValue(), expected[1].doubleValue()}).returns(Tuple::getArrayOfNumerics, Row::getArrayOfNumerics, (Object[])new Numeric[]{Numeric.create((Number)expected[0]), Numeric.create((Number)expected[1])}).returns(Numeric.class, (Object[])expected).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }
}

