/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.pgclient.data.Money;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;

public class MonetaryTypeExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeMoney(TestContext ctx) {
        this.testDecode(ctx, "SELECT 1234.45::MONEY, (-1234.45)::MONEY", Tuple::getValue, new Money(1234L, 45), new Money(-1234L, 45));
    }

    @Test
    public void testEncodeMoney(TestContext ctx) {
        this.testEncode(ctx, "SELECT ($1::MONEY)::VARCHAR, ($2::MONEY)::VARCHAR", Tuple.of((Object)new Money(1234L, 45), (Object)new Money(-1234L, 45)), "$1,234.45", "-$1,234.45");
    }

    @Test
    public void testDecodeMoneyArray(TestContext ctx) {
        this.testDecode(ctx, "SELECT '{ 1234.45, -1234.45 }'::MONEY[]", Tuple::getValue, new Object[]{new Money[]{new Money(1234L, 45), new Money(-1234L, 45)}});
    }

    @Test
    public void testEncodeMoneyArray(TestContext ctx) {
        this.testEncode(ctx, "SELECT (($1::MONEY[])[1])::VARCHAR", Tuple.of((Object)new Money[]{new Money(1234L, 45)}), "$1,234.45");
    }
}

