/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.math.BigDecimal;
import org.junit.Test;

public class JsonTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testJSON(TestContext ctx) {
        this.testJson(ctx, "JSON");
    }

    @Test
    public void testJSONB(TestContext ctx) {
        this.testJson(ctx, "JSONB");
    }

    private void testJson(TestContext ctx, String jsonType) {
        this.testGeneric(ctx, "SELECT c FROM (VALUES ($1 :: " + jsonType + ")) AS t (c)", new Object[]{10, true, "hello", new JsonObject().put("foo", (Object)"bar"), new JsonArray().add((Object)0).add((Object)1).add((Object)2)}, Object.class);
    }

    @Test
    public void testJSONArray(TestContext ctx) {
        this.testJsonArray(ctx, "JSON");
    }

    @Test
    public void testJSONBArray(TestContext ctx) {
        this.testJsonArray(ctx, "JSONB");
    }

    private void testJsonArray(TestContext ctx, String jsonType) {
        this.testGenericArray(ctx, "SELECT c FROM (VALUES ($1 :: " + jsonType + "[])) AS t (c)", new Object[][]{{10, true, "hello", new JsonObject().put("foo", (Object)"bar"), new JsonArray().add((Object)0).add((Object)1).add((Object)2)}}, Object.class);
    }

    @Test
    public void testDecodeJson(TestContext ctx) {
        this.testDecodeJson(ctx, "JsonDataType");
    }

    @Test
    public void testDecodeJsonb(TestContext ctx) {
        this.testDecodeJson(ctx, "JsonbDataType");
    }

    private void testDecodeJson(TestContext ctx, String tableName) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"JsonObject\", \"JsonArray\", \"Number\", \"String\", \"BooleanTrue\", \"BooleanFalse\", \"NullValue\", \"Null\" FROM \"" + tableName + "\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            JsonObject object = new JsonObject("{\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []}");
            JsonArray array = new JsonArray("[1,true,null,9.5,\"Hi\"]");
            ColumnChecker.checkColumn((int)0, (String)"JsonObject").returns(Tuple::getValue, Row::getValue, (Object)object).returns(Tuple::getJsonObject, Row::getJsonObject, (Object)object).returns(Tuple::getJson, Row::getJson, (Object)object).returns(JsonObject.class, (Object)object).forRow(row);
            ColumnChecker.checkColumn((int)1, (String)"JsonArray").returns(Tuple::getValue, Row::getValue, (Object)array).returns(Tuple::getJsonArray, Row::getJsonArray, (Object)array).returns(Tuple::getJson, Row::getJson, (Object)array).returns(JsonArray.class, (Object)array).forRow(row);
            ColumnChecker.checkColumn((int)2, (String)"Number").returns(Tuple::getValue, Row::getValue, (Object)4).returns(Tuple::getJson, Row::getJson, (Object)4).returns(Tuple::getShort, Row::getShort, (Object)4).returns(Tuple::getInteger, Row::getInteger, (Object)4).returns(Tuple::getLong, Row::getLong, (Object)4L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(4.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)4.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(4)).returns(Object.class, (Object)4).forRow(row);
            ColumnChecker.checkColumn((int)3, (String)"String").returns(Tuple::getValue, Row::getValue, (Object)"Hello World").returns(Tuple::getString, Row::getString, (Object)"Hello World").returns(Tuple::getJson, Row::getJson, (Object)"Hello World").returns(String.class, (Object)"Hello World").forRow(row);
            ColumnChecker.checkColumn((int)4, (String)"BooleanTrue").returns(Tuple::getValue, Row::getValue, (Object)true).returns(Tuple::getBoolean, Row::getBoolean, (Object)true).returns(Tuple::getJson, Row::getJson, (Object)true).returns(Boolean.class, (Object)true).forRow(row);
            ColumnChecker.checkColumn((int)5, (String)"BooleanFalse").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).returns(Tuple::getJson, Row::getJson, (Object)false).returns(Boolean.class, (Object)false).forRow(row);
            ColumnChecker.checkColumn((int)6, (String)"NullValue").returns(Tuple::getValue, Row::getValue, Tuple.JSON_NULL).returns(Object.class, Tuple.JSON_NULL).returns(Tuple::getJson, Row::getJson, Tuple.JSON_NULL).forRow(row);
            ColumnChecker.checkColumn((int)7, (String)"Null").returnsNull().forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeJson(TestContext ctx) {
        this.testEncodeJson(ctx, "JsonDataType");
    }

    @Test
    public void testEncodeJsonb(TestContext ctx) {
        this.testEncodeJson(ctx, "JsonbDataType");
    }

    private void testEncodeJson(TestContext ctx, String tableName) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"" + tableName + "\" SET \"JsonObject\" = $1, \"JsonArray\" = $2, \"Number\" = $3, \"String\" = $4, \"BooleanTrue\" = $5, \"BooleanFalse\" = $6, \"NullValue\" = $7, \"Null\" = $8 WHERE \"id\" = $9 RETURNING \"JsonObject\", \"JsonArray\", \"Number\", \"String\", \"BooleanTrue\", \"BooleanFalse\", \"NullValue\", \"Null\"", ctx.asyncAssertSuccess(p -> {
            JsonObject object = new JsonObject("{\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []}");
            JsonArray array = new JsonArray("[1,true,null,9.5,\"Hi\"]");
            p.query().execute(Tuple.tuple().addValue((Object)object).addValue((Object)array).addValue((Object)4).addValue((Object)"Hello World").addValue((Object)true).addValue((Object)false).addValue(Tuple.JSON_NULL).addValue(null).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"JsonObject").returns(Tuple::getValue, Row::getValue, (Object)object).returns(Tuple::getJsonObject, Row::getJsonObject, (Object)object).returns(Tuple::getJson, Row::getJson, (Object)object).returns(JsonObject.class, (Object)object).forRow(row);
                ColumnChecker.checkColumn((int)1, (String)"JsonArray").returns(Tuple::getValue, Row::getValue, (Object)array).returns(Tuple::getJsonArray, Row::getJsonArray, (Object)array).returns(Tuple::getJson, Row::getJson, (Object)array).returns(JsonArray.class, (Object)array).forRow(row);
                ColumnChecker.checkColumn((int)2, (String)"Number").returns(Tuple::getValue, Row::getValue, (Object)4).returns(Tuple::getJson, Row::getJson, (Object)4).returns(Tuple::getShort, Row::getShort, (Object)4).returns(Tuple::getInteger, Row::getInteger, (Object)4).returns(Tuple::getLong, Row::getLong, (Object)4L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(4.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)4.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(4)).returns(Object.class, (Object)4).forRow(row);
                ColumnChecker.checkColumn((int)3, (String)"String").returns(Tuple::getValue, Row::getValue, (Object)"Hello World").returns(Tuple::getJson, Row::getJson, (Object)"Hello World").returns(Tuple::getString, Row::getString, (Object)"Hello World").returns(String.class, (Object)"Hello World").forRow(row);
                ColumnChecker.checkColumn((int)4, (String)"BooleanTrue").returns(Tuple::getValue, Row::getValue, (Object)true).returns(Tuple::getJson, Row::getJson, (Object)true).returns(Tuple::getBoolean, Row::getBoolean, (Object)true).returns(Boolean.class, (Object)true).forRow(row);
                ColumnChecker.checkColumn((int)5, (String)"BooleanFalse").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getJson, Row::getJson, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).returns(Boolean.class, (Object)false).forRow(row);
                ColumnChecker.checkColumn((int)6, (String)"NullValue").returns(Tuple::getValue, Row::getValue, Tuple.JSON_NULL).returns(Tuple::getJson, Row::getJson, Tuple.JSON_NULL).returns(Object.class, Tuple.JSON_NULL).forRow(row);
                ColumnChecker.checkColumn((int)7, (String)"Null").returnsNull().forRow(row);
                async.complete();
            }));
        }))));
    }
}

