/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;

public class JavaEnumTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testJavaEnumToEnumColumn(TestContext ctx) {
        this.testJavaEnumToColumn(ctx, "'unhappy'", "Mood");
    }

    @Test
    public void testJavaEnumToTEXTColumn(TestContext ctx) {
        this.testJavaEnumToColumn(ctx, "'unhappy'", "TEXT");
    }

    @Test
    public void testJavaEnumToVARCHARColumn(TestContext ctx) {
        this.testJavaEnumToColumn(ctx, "'unhappy'", "VARCHAR");
    }

    @Test
    public void testJavaEnumToINT4Column(TestContext ctx) {
        this.testJavaEnumToColumn(ctx, "0", "INT4");
    }

    private void testJavaEnumToColumn(TestContext ctx, String value, String sqlType) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM (VALUES (" + value + " :: " + sqlType + ")) AS t (c)").execute(ctx.asyncAssertSuccess(v -> {
            RowIterator it = v.iterator();
            ctx.assertTrue(it.hasNext());
            Row row = (Row)it.next();
            ctx.assertEquals((Object)Mood.unhappy, row.get(Mood.class, 0));
        }))));
    }

    @Test
    public void testJavaEnumToEnumArrayColumn(TestContext ctx) {
        this.testJavaEnumToArrayColumn(ctx, "ARRAY['unhappy']", "Mood[]");
    }

    @Test
    public void testJavaEnumToTEXTArrayColumn(TestContext ctx) {
        this.testJavaEnumToArrayColumn(ctx, "ARRAY['unhappy']", "TEXT[]");
    }

    @Test
    public void testJavaEnumToVARCHARArrayColumn(TestContext ctx) {
        this.testJavaEnumToArrayColumn(ctx, "ARRAY['unhappy']", "VARCHAR[]");
    }

    @Test
    public void testJavaEnumToINT4ArrayColumn(TestContext ctx) {
        this.testJavaEnumToArrayColumn(ctx, "ARRAY[0]", "INT4[]");
    }

    private void testJavaEnumToArrayColumn(TestContext ctx, String value, String sqlType) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM (VALUES (" + value + " :: " + sqlType + ")) AS t (c)").execute(ctx.asyncAssertSuccess(v -> {
            RowIterator it = v.iterator();
            ctx.assertTrue(it.hasNext());
            Row row = (Row)it.next();
            Mood[] result = (Mood[])row.get(Mood[].class, "c");
            ctx.assertEquals((Object)1, (Object)result.length);
            ctx.assertEquals((Object)Mood.unhappy, (Object)result[0]);
        }))));
    }

    @Test
    public void testJavaEnumToEnumParam(TestContext ctx) {
        this.testJavaEnumToParam(ctx, "happy", "Mood");
    }

    @Test
    public void testJavaEnumToVARCHARParam(TestContext ctx) {
        this.testJavaEnumToParam(ctx, "happy", "VARCHAR");
    }

    @Test
    public void testJavaEnumToTEXTParam(TestContext ctx) {
        this.testJavaEnumToParam(ctx, "happy", "TEXT");
    }

    @Test
    public void testJavaEnumToINT2Param(TestContext ctx) {
        this.testJavaEnumToParam(ctx, (short)Mood.happy.ordinal(), "INT2");
    }

    @Test
    public void testJavaEnumToINT4Param(TestContext ctx) {
        this.testJavaEnumToParam(ctx, Mood.happy.ordinal(), "INT4");
    }

    @Test
    public void testJavaEnumToINT8Param(TestContext ctx) {
        this.testJavaEnumToParam(ctx, Mood.happy.ordinal(), "INT8");
    }

    private void testJavaEnumToParam(TestContext ctx, Object expected, String sqlType) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT $1 :: " + sqlType + " \"c\"").execute(Tuple.of((Object)((Object)Mood.happy)), ctx.asyncAssertSuccess(v -> {
            RowIterator it = v.iterator();
            ctx.assertTrue(it.hasNext());
            Row row = (Row)it.next();
            ctx.assertEquals(expected, row.getValue(0));
        }))));
    }

    @Test
    public void testJavaEnumToEnumArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, "happy", "Mood[]");
    }

    @Test
    public void testJavaEnumToVARCHARArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, "happy", "VARCHAR[]");
    }

    @Test
    public void testJavaEnumToTEXTArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, "happy", "TEXT[]");
    }

    @Test
    public void testJavaEnumToINT2ArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, (short)Mood.happy.ordinal(), "INT2[]");
    }

    @Test
    public void testJavaEnumToINT4ArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, Mood.happy.ordinal(), "INT4[]");
    }

    @Test
    public void testJavaEnumToINT8ArrayParam(TestContext ctx) {
        this.testJavaEnumToArrayParam(ctx, Mood.happy.ordinal(), "INT8[]");
    }

    private void testJavaEnumToArrayParam(TestContext ctx, Object expected, String sqlType) {
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT $1 :: " + sqlType + " \"c\"").execute(Tuple.of((Object)new Mood[]{Mood.happy}), ctx.asyncAssertSuccess(v -> {
            RowIterator it = v.iterator();
            ctx.assertTrue(it.hasNext());
            Row row = (Row)it.next();
            Object value = row.getValue(0);
            ctx.assertTrue(value instanceof Object[]);
            Object[] array = (Object[])value;
            ctx.assertEquals((Object)1, (Object)array.length);
            ctx.assertEquals(expected, array[0]);
        }))));
    }

    public static enum Mood {
        unhappy,
        ok,
        happy;

    }
}

