/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.Arrays;
import org.junit.Test;

public class GeometricTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodePoint(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: POINT \"Point\"", new Point[]{new Point(1.0, 2.0)}, Point.class);
    }

    @Test
    public void testDecodeLine(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: LINE \"Line\"", new Line[]{new Line(1.0, 2.0, 3.0)}, Line.class);
    }

    @Test
    public void testDecodeLineSegment(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: LSEG \"Lseg\"", new LineSegment[]{new LineSegment(new Point(1.0, 1.0), new Point(2.0, 2.0))}, LineSegment.class);
    }

    @Test
    public void testDecodeBox(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: BOX \"Box\"", new Box[]{new Box(new Point(2.0, 2.0), new Point(1.0, 1.0))}, Box.class);
    }

    @Test
    public void testDecodeClosedPath(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: PATH \"ClosedPath\"", new Path[]{new Path(false, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0)))}, Path.class);
    }

    @Test
    public void testDecodeOpenPath(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: PATH \"OpenPath\"", new Path[]{new Path(true, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0)))}, Path.class);
    }

    @Test
    public void testDecodePolygon(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: POLYGON \"Polygon\"", new Polygon[]{new Polygon(Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 2.0), new Point(3.0, 1.0)))}, Polygon.class);
    }

    @Test
    public void testDecodeCircle(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: CIRCLE \"Circle\"", new Circle[]{new Circle(new Point(1.0, 1.0), 1.0)}, Circle.class);
    }

    @Test
    public void testDecodePointArray(TestContext ctx) {
        Point[] points = new Point[]{new Point(1.0, 1.0), new Point(2.0, 2.0)};
        this.testGenericArray(ctx, "SELECT $1 :: POINT[] \"PointArray\"", new Point[][]{points}, Point.class);
    }

    @Test
    public void testDecodeLineArray(TestContext ctx) {
        Line[] lines = new Line[]{new Line(1.0, 2.0, 3.0), new Line(2.0, 3.0, 4.0)};
        this.testGenericArray(ctx, "SELECT $1 :: LINE[] \"LineArray\"", new Line[][]{lines}, Line.class);
    }

    @Test
    public void testDecodeLineSegmentArray(TestContext ctx) {
        LineSegment[] lineSegments = new LineSegment[]{new LineSegment(new Point(1.0, 1.0), new Point(2.0, 2.0)), new LineSegment(new Point(2.0, 2.0), new Point(3.0, 3.0))};
        this.testGenericArray(ctx, "SELECT $1 :: LSEG[] \"LsegArray\"", new LineSegment[][]{lineSegments}, LineSegment.class);
    }

    @Test
    public void testDecodeBoxArray(TestContext ctx) {
        Box[] boxes = new Box[]{new Box(new Point(2.0, 2.0), new Point(1.0, 1.0)), new Box(new Point(3.0, 3.0), new Point(2.0, 2.0))};
        this.testGenericArray(ctx, "SELECT $1 :: BOX[] \"BoxArray\"", new Box[][]{boxes}, Box.class);
    }

    @Test
    public void testDecodeClosedPathArray(TestContext ctx) {
        Path[] closedPaths = new Path[]{new Path(false, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0))), new Path(false, Arrays.asList(new Point(2.0, 2.0), new Point(3.0, 2.0), new Point(3.0, 3.0), new Point(3.0, 2.0)))};
        this.testGenericArray(ctx, "SELECT $1 :: PATH[] \"ClosedPathArray\"", new Path[][]{closedPaths}, Path.class);
    }

    @Test
    public void testDecodeOpenPathArray(TestContext ctx) {
        Path[] openPaths = new Path[]{new Path(true, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0))), new Path(true, Arrays.asList(new Point(2.0, 2.0), new Point(3.0, 2.0), new Point(3.0, 3.0), new Point(3.0, 2.0)))};
        this.testGenericArray(ctx, "SELECT $1 :: PATH[] \"OpenPathArray\"", new Path[][]{openPaths}, Path.class);
    }

    @Test
    public void testDecodePolygonArray(TestContext ctx) {
        Polygon[] polygons = new Polygon[]{new Polygon(Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 2.0), new Point(3.0, 1.0))), new Polygon(Arrays.asList(new Point(0.0, 0.0), new Point(0.0, 1.0), new Point(1.0, 2.0), new Point(2.0, 1.0), new Point(2.0, 0.0)))};
        this.testGenericArray(ctx, "SELECT $1 :: POLYGON[] \"PolygonArray\"", new Polygon[][]{polygons}, Polygon.class);
    }

    @Test
    public void testDecodeCircleArray(TestContext ctx) {
        Circle[] circles = new Circle[]{new Circle(new Point(1.0, 1.0), 1.0), new Circle(new Point(0.0, 0.0), 2.0)};
        this.testGenericArray(ctx, "SELECT $1 :: CIRCLE[] \"CircleArray\"", new Circle[][]{circles}, Circle.class);
    }

    @Test
    public void testEncodeGeometric(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"GeometricDataType\" SET \"Point\" = $1, \"Line\" = $2, \"Lseg\" = $3, \"Box\" = $4, \"ClosedPath\" = $5, \"OpenPath\" = $6, \"Polygon\" = $7, \"Circle\" = $8 WHERE \"id\" = $9 RETURNING \"Point\", \"Line\", \"Lseg\", \"Box\", \"ClosedPath\", \"OpenPath\", \"Polygon\", \"Circle\"", ctx.asyncAssertSuccess(p -> {
            Point point = new Point(2.0, 3.0);
            Line line = new Line(2.0, 3.0, 4.0);
            LineSegment lineSegment = new LineSegment(new Point(2.0, 2.0), new Point(3.0, 3.0));
            Box box = new Box(new Point(3.0, 3.0), new Point(2.0, 2.0));
            Path OpenPath = new Path(true, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0)));
            Path closedPath = new Path(false, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0)));
            Polygon polygon = new Polygon(Arrays.asList(new Point(2.0, 2.0), new Point(3.0, 3.0), new Point(4.0, 2.0)));
            Circle circle = new Circle(new Point(1.0, 1.0), 3.0);
            int id = 2;
            p.query().execute(Tuple.tuple().addValue((Object)point).addValue((Object)line).addValue((Object)lineSegment).addValue((Object)box).addValue((Object)OpenPath).addValue((Object)closedPath).addValue((Object)polygon).addValue((Object)circle).addInteger(Integer.valueOf(id)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Point").returns(Tuple::getValue, Row::getValue, (Object)point).returns(Point.class, (Object)point).forRow(row);
                ColumnChecker.checkColumn((int)1, (String)"Line").returns(Tuple::getValue, Row::getValue, (Object)line).returns(Line.class, (Object)line).forRow(row);
                ColumnChecker.checkColumn((int)2, (String)"Lseg").returns(Tuple::getValue, Row::getValue, (Object)lineSegment).returns(LineSegment.class, (Object)lineSegment).forRow(row);
                ColumnChecker.checkColumn((int)3, (String)"Box").returns(Tuple::getValue, Row::getValue, (Object)box).returns(Box.class, (Object)box).forRow(row);
                ColumnChecker.checkColumn((int)4, (String)"ClosedPath").returns(Tuple::getValue, Row::getValue, (Object)OpenPath).returns(Path.class, (Object)OpenPath).forRow(row);
                ColumnChecker.checkColumn((int)5, (String)"OpenPath").returns(Tuple::getValue, Row::getValue, (Object)closedPath).returns(Path.class, (Object)closedPath).forRow(row);
                ColumnChecker.checkColumn((int)6, (String)"Polygon").returns(Tuple::getValue, Row::getValue, (Object)polygon).returns(Polygon.class, (Object)polygon).forRow(row);
                ColumnChecker.checkColumn((int)7, (String)"Circle").returns(Tuple::getValue, Row::getValue, (Object)circle).returns(Circle.class, (Object)circle).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testEncodeGeometricArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Point\" = $1, \"Line\" = $2, \"Lseg\" = $3, \"Box\" = $4, \"ClosedPath\" = $5, \"OpenPath\" = $6, \"Polygon\" = $7, \"Circle\" = $8 WHERE \"id\" = $9 RETURNING \"Point\", \"Line\", \"Lseg\", \"Box\", \"ClosedPath\", \"OpenPath\", \"Polygon\", \"Circle\"", ctx.asyncAssertSuccess(p -> {
            Point[] points = new Point[]{new Point(2.0, 2.0), new Point(1.0, 1.0)};
            Line[] lines = new Line[]{new Line(3.0, 2.0, 1.0), new Line(2.0, 3.0, 4.0)};
            LineSegment[] lineSegments = new LineSegment[]{new LineSegment(new Point(1.0, 1.0), new Point(-3.0, -2.0)), new LineSegment(new Point(2.0, 2.0), new Point(3.0, 3.0))};
            Box[] boxes = new Box[]{new Box(new Point(2.0, 2.0), new Point(1.0, 1.0)), new Box(new Point(4.0, 4.0), new Point(2.0, 2.0))};
            Path[] openPaths = new Path[]{new Path(true, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0))), new Path(false, Arrays.asList(new Point(2.0, 2.0), new Point(3.0, 2.0), new Point(3.0, 3.0), new Point(3.0, 2.0)))};
            Path[] closedPaths = new Path[]{new Path(false, Arrays.asList(new Point(1.0, 1.0), new Point(2.0, 1.0), new Point(2.0, 2.0), new Point(2.0, 1.0))), new Path(false, Arrays.asList(new Point(2.0, 2.0), new Point(3.0, 2.0), new Point(3.0, 3.0), new Point(3.0, 2.0)))};
            Polygon[] polygons = new Polygon[]{new Polygon(Arrays.asList(new Point(0.0, 0.0), new Point(2.0, 2.0), new Point(3.0, 1.0))), new Polygon(Arrays.asList(new Point(0.0, 0.0), new Point(0.0, 1.0), new Point(1.0, 2.0), new Point(2.0, 1.0), new Point(2.0, 0.0)))};
            Circle[] circles = new Circle[]{new Circle(new Point(1.0, 1.0), 3.0), new Circle(new Point(2.0, 2.0), 2.0)};
            int id = 2;
            p.query().execute(Tuple.tuple().addValue((Object)points).addValue((Object)lines).addValue((Object)lineSegments).addValue((Object)boxes).addValue((Object)openPaths).addValue((Object)closedPaths).addValue((Object)polygons).addValue((Object)circles).addInteger(Integer.valueOf(id)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Point").returns(Tuple::getValue, Row::getValue, (Object[])points).returns(Point.class, (Object[])points).forRow(row);
                ColumnChecker.checkColumn((int)1, (String)"Line").returns(Tuple::getValue, Row::getValue, (Object[])lines).returns(Line.class, (Object[])lines).forRow(row);
                ColumnChecker.checkColumn((int)2, (String)"Lseg").returns(Tuple::getValue, Row::getValue, (Object[])lineSegments).returns(LineSegment.class, (Object[])lineSegments).forRow(row);
                ColumnChecker.checkColumn((int)3, (String)"Box").returns(Tuple::getValue, Row::getValue, (Object[])boxes).returns(Box.class, (Object[])boxes).forRow(row);
                ColumnChecker.checkColumn((int)4, (String)"ClosedPath").returns(Tuple::getValue, Row::getValue, (Object[])openPaths).returns(Path.class, (Object[])openPaths).forRow(row);
                ColumnChecker.checkColumn((int)5, (String)"OpenPath").returns(Tuple::getValue, Row::getValue, (Object[])closedPaths).returns(Path.class, (Object[])closedPaths).forRow(row);
                ColumnChecker.checkColumn((int)6, (String)"Polygon").returns(Tuple::getValue, Row::getValue, (Object[])polygons).returns(Polygon.class, (Object[])polygons).forRow(row);
                ColumnChecker.checkColumn((int)7, (String)"Circle").returns(Tuple::getValue, Row::getValue, (Object[])circles).returns(Circle.class, (Object[])circles).forRow(row);
                async.complete();
            }));
        }))));
    }
}

