/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.DataTypeTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ExtendedQueryDataTypeCodecTestBase
extends DataTypeTestBase {
    private static <T> void compare(TestContext ctx, T expected, T actual) {
        if (expected != null && expected.getClass().isArray()) {
            ctx.assertNotNull(actual);
            ctx.assertTrue(actual.getClass().isArray());
            List<Object> expectedList = Arrays.asList((Object[])expected);
            List<Object> actualList = Arrays.asList((Object[])actual);
            ctx.assertEquals(expectedList, actualList);
        } else {
            ctx.assertEquals(expected, actual);
        }
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.options.setCachePreparedStatements(false);
    }

    protected <T> void testGeneric(TestContext ctx, String sql, T[] expected, Class<T> type) {
        this.testGeneric(ctx, sql, expected, (Row row, Integer idx) -> row.get(type, idx.intValue()));
    }

    protected <T> void testGenericArray(TestContext ctx, String sql, T[][] expected, Class<T> type) {
        this.testGeneric(ctx, sql, (T[])expected, (BiFunction<Row, Integer, T>)((BiFunction<Row, Integer, Object>)(row, idx) -> row.get(Array.newInstance(type, 0).getClass(), idx.intValue())));
    }

    protected <T> void testGeneric(TestContext ctx, String sql, T[] expected, BiFunction<Row, Integer, T> getter) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            List batch = Stream.of(expected).map(Tuple::of).collect(Collectors.toList());
            conn.preparedQuery(sql).executeBatch(batch, ctx.asyncAssertSuccess(result -> {
                for (Object n : expected) {
                    ctx.assertEquals((Object)result.size(), (Object)1);
                    RowIterator it = result.iterator();
                    Row row = (Row)it.next();
                    ExtendedQueryDataTypeCodecTestBase.compare(ctx, n, getter.apply(row, 0));
                    ExtendedQueryDataTypeCodecTestBase.compare(ctx, n, row.getValue(0));
                    result = result.next();
                }
                ctx.assertNull(result);
                async.complete();
            }));
        }));
    }

    protected <T> void testDecode(TestContext ctx, String sql, BiFunction<Row, Integer, T> getter, T ... expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(sql).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)result.size(), (Object)1);
            RowIterator it = result.iterator();
            Row row = (Row)it.next();
            ctx.assertEquals((Object)row.size(), (Object)expected.length);
            for (int idx = 0; idx < expected.length; ++idx) {
                ExtendedQueryDataTypeCodecTestBase.compare(ctx, expected[idx], getter.apply(row, idx));
                ExtendedQueryDataTypeCodecTestBase.compare(ctx, expected[idx], row.getValue(idx));
            }
            async.complete();
        }))));
    }

    protected <T> void testEncode(TestContext ctx, String sql, Tuple tuple, String ... expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(sql).execute(tuple, ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)result.size(), (Object)1);
            RowIterator it = result.iterator();
            Row row = (Row)it.next();
            ctx.assertEquals((Object)row.size(), (Object)expected.length);
            for (int idx = 0; idx < expected.length; ++idx) {
                ExtendedQueryDataTypeCodecTestBase.compare(ctx, expected[idx], row.getString(idx));
            }
            async.complete();
        }))));
    }
}

