/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.pgclient.data.Interval;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import org.junit.Test;

public class DateTimeTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeDateBeforePgEpoch(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "DATE", "Date", Tuple::getLocalDate, Row::getLocalDate, LocalDate.parse("1981-05-30"));
    }

    @Test
    public void testDecodeDatePlusInfinity(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "DATE", "Date", Tuple::getLocalDate, Row::getLocalDate, LocalDate.MAX);
    }

    @Test
    public void testDecodeDateMinuxInfinity(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "DATE", "Date", Tuple::getLocalDate, Row::getLocalDate, LocalDate.MIN);
    }

    @Test
    public void testEncodeDateBeforePgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"Date\" = $1 WHERE \"id\" = $2 RETURNING \"Date\"", ctx.asyncAssertSuccess(p -> {
            LocalDate ld = LocalDate.parse("1981-06-30");
            p.query().execute(Tuple.tuple().addLocalDate(ld).addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Date").returns(Tuple::getValue, Row::getValue, (Object)ld).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ld).returns(Tuple::getTemporal, Row::getTemporal, (Object)ld).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeDateAfterPgEpoch(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "DATE", "Date", Tuple::getLocalDate, Row::getLocalDate, LocalDate.parse("2017-05-30"));
    }

    @Test
    public void testEncodeDateAfterPgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"Date\" = $1 WHERE \"id\" = $2 RETURNING \"Date\"", ctx.asyncAssertSuccess(p -> {
            LocalDate ld = LocalDate.parse("2018-05-30");
            p.query().execute(Tuple.tuple().addLocalDate(ld).addInteger(Integer.valueOf(4)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Date").returns(Tuple::getValue, Row::getValue, (Object)ld).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ld).returns(Tuple::getTemporal, Row::getTemporal, (Object)ld).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeTime(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "TIME WITHOUT TIME ZONE", "Time", Tuple::getLocalTime, Row::getLocalTime, LocalTime.parse("17:55:04.905120"));
    }

    @Test
    public void testEncodeTime(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE  \"TemporalDataType\" SET \"Time\" = $1 WHERE \"id\" = $2 RETURNING \"Time\"", ctx.asyncAssertSuccess(p -> {
            LocalTime lt = LocalTime.parse("22:55:04.905120");
            p.query().execute(Tuple.tuple().addLocalTime(lt).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Time").returns(Tuple::getValue, Row::getValue, (Object)lt).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)lt).returns(Tuple::getTemporal, Row::getTemporal, (Object)lt).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeTimeTz(TestContext ctx) {
        this.testDecodeDataTimeGeneric(ctx, "TIME WITH TIME ZONE", "TimeTz", Tuple::getOffsetTime, Row::getOffsetTime, OffsetTime.parse("17:55:04.905120+03:07"));
    }

    @Test
    public void testEncodeTimeTz(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"TimeTz\" = $1 WHERE \"id\" = $2 RETURNING \"TimeTz\"", ctx.asyncAssertSuccess(p -> {
            OffsetTime ot = OffsetTime.parse("20:55:04.905120+03:07");
            p.query().execute(Tuple.tuple().addOffsetTime(ot).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"TimeTz").returns(Tuple::getValue, Row::getValue, (Object)ot).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)ot).returns(Tuple::getTemporal, Row::getTemporal, (Object)ot).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeTimestampBeforePgEpoch(TestContext ctx) {
        LocalDateTime expected = LocalDateTime.parse("1800-01-01T23:57:53.237666");
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITHOUT TIME ZONE", "Timestamp", checker, expected);
    }

    @Test
    public void testDecodeTimestampPlusInfinity(TestContext ctx) {
        LocalDateTime expected = LocalDateTime.MAX;
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITHOUT TIME ZONE", "Timestamp", checker, expected);
    }

    @Test
    public void testDecodeTimestampMinusInfinity(TestContext ctx) {
        LocalDateTime expected = LocalDateTime.MIN;
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITHOUT TIME ZONE", "Timestamp", checker, expected);
    }

    @Test
    public void testEncodeTimestampBeforePgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"Timestamp\" = $1 WHERE \"id\" = $2 RETURNING \"Timestamp\"", ctx.asyncAssertSuccess(p -> {
            LocalDateTime ldt = LocalDateTime.parse("1900-02-01T23:57:53.237666");
            p.query().execute(Tuple.tuple().addLocalDateTime(ldt).addInteger(Integer.valueOf(4)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)ldt).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ldt.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)ldt.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)ldt).returns(Tuple::getTemporal, Row::getTemporal, (Object)ldt).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeTimestampAfterPgEpoch(TestContext ctx) {
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)ldt).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ldt.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)ldt.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)ldt).returns(Tuple::getTemporal, Row::getTemporal, (Object)ldt);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITHOUT TIME ZONE", "Timestamp", checker, ldt);
    }

    @Test
    public void testEncodeTimestampAfterPgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"Timestamp\" =$1 WHERE \"id\" = $2 RETURNING \"Timestamp\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addLocalDateTime(LocalDateTime.parse("2017-05-14T19:35:58.237666")).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            LocalDateTime ldt = LocalDateTime.parse("2017-05-14T19:35:58.237666");
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Timestamp").returns(Tuple::getValue, Row::getValue, (Object)ldt).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)ldt.toLocalTime()).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)ldt.toLocalDate()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)ldt).returns(Tuple::getTemporal, Row::getTemporal, (Object)ldt).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeTimestampTzBeforePgEpoch(TestContext ctx) {
        OffsetDateTime expected = OffsetDateTime.parse("1800-01-02T02:59:59.237666Z");
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)expected.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)expected).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITH TIME ZONE", "TimestampTz", checker, expected);
    }

    @Test
    public void testDecodeTimestampTzPlusInfinity(TestContext ctx) {
        OffsetDateTime expected = OffsetDateTime.MAX;
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)expected.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)expected).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITH TIME ZONE", "TimestampTz", checker, expected);
    }

    @Test
    public void testDecodeTimestampTzMinusInfinity(TestContext ctx) {
        OffsetDateTime expected = OffsetDateTime.MIN;
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)expected.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)expected).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITH TIME ZONE", "TimestampTz", checker, expected);
    }

    @Test
    public void testEncodeTimestampTzBeforePgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(v -> conn.prepare("UPDATE \"TemporalDataType\" SET \"TimestampTz\" =$1 WHERE \"id\" = $2 RETURNING \"TimestampTz\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addOffsetDateTime(OffsetDateTime.parse("1800-02-01T23:59:59.237666-03:00")).addInteger(Integer.valueOf(3)), ctx.asyncAssertSuccess(result -> {
            OffsetDateTime odt = OffsetDateTime.parse("1800-02-02T02:59:59.237666Z");
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)odt).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)odt.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)odt).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)odt.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)odt.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)odt.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)odt).forRow(row);
            async.complete();
        }))))))));
    }

    @Test
    public void testDecodeTimestampTzAfterPgEpoch(TestContext ctx) {
        OffsetDateTime expected = OffsetDateTime.parse("2017-05-15T02:59:59.237666Z");
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)expected.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)expected).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)expected.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)expected.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)expected.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)expected);
        this.testDecodeDataTimeGeneric(ctx, "TIMESTAMP WITH TIME ZONE", "TimestampTz", checker, expected);
    }

    @Test
    public void testEncodeTimestampTzAfterPgEpoch(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SET TIME ZONE 'UTC'").execute(ctx.asyncAssertSuccess(v -> conn.prepare("UPDATE \"TemporalDataType\" SET \"TimestampTz\" = $1 WHERE \"id\" = $2 RETURNING \"TimestampTz\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addOffsetDateTime(OffsetDateTime.parse("2017-06-14T23:59:59.237666-03:00")).addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            OffsetDateTime odt = OffsetDateTime.parse("2017-06-15T02:59:59.237666Z");
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"TimestampTz").returns(Tuple::getValue, Row::getValue, (Object)odt).returns(Tuple::getOffsetTime, Row::getOffsetTime, (Object)odt.toOffsetTime()).returns(Tuple::getOffsetDateTime, Row::getOffsetDateTime, (Object)odt).returns(Tuple::getLocalDate, Row::getLocalDate, (Object)odt.toLocalDate()).returns(Tuple::getLocalTime, Row::getLocalTime, (Object)odt.toLocalTime()).returns(Tuple::getLocalDateTime, Row::getLocalDateTime, (Object)odt.toLocalDateTime()).returns(Tuple::getTemporal, Row::getTemporal, (Object)odt).forRow(row);
            async.complete();
        }))))))));
    }

    @Test
    public void testDecodeInterval(TestContext ctx) {
        Interval interval = Interval.of().years(10).months(3).days(332).hours(20).minutes(20).seconds(20).microseconds(999999);
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: INTERVAL \"Interval\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addValue((Object)interval), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"Interval").returns(Tuple::getValue, Row::getValue, (Object)interval).returns(Interval.class, (Object)interval).forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeInterval(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"TemporalDataType\" SET \"Interval\" = $1 WHERE \"id\" = $2 RETURNING \"Interval\"", ctx.asyncAssertSuccess(p -> {
            Interval expected = Interval.of().years(2000).months(1).days(403).hours(59).minutes(35).seconds(13).microseconds(999998);
            p.query().execute(Tuple.tuple().addValue((Object)expected).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"Interval").returns(Tuple::getValue, Row::getValue, (Object)expected).returns(Interval.class, (Object)expected).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeLocalDateArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: DATE [] \"LocalDate\"", new LocalDate[][]{{LocalDate.parse("1998-05-11"), LocalDate.parse("1998-05-11")}}, Tuple::getArrayOfLocalDates);
    }

    @Test
    public void testEncodeLocalDateArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"LocalDate\" = $1  WHERE \"id\" = $2 RETURNING \"LocalDate\"", ctx.asyncAssertSuccess(p -> {
            LocalDate dt = LocalDate.parse("1998-05-12");
            p.query().execute(Tuple.tuple().addArrayOfLocalDate(new LocalDate[]{dt}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"LocalDate").returns(Tuple::getValue, Row::getValue, (Object[])new LocalDate[]{dt}).returns(Tuple::getArrayOfLocalDates, Row::getArrayOfLocalDates, (Object[])new LocalDate[]{dt}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeLocalTimeArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: TIME WITHOUT TIME ZONE [] \"LocalTime\"", new LocalTime[][]{{lt}}, Tuple::getArrayOfLocalTimes);
    }

    @Test
    public void testEncodeLocalTimeArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"LocalTime\" = $1  WHERE \"id\" = $2 RETURNING \"LocalTime\"", ctx.asyncAssertSuccess(p -> {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSS");
            LocalTime dt = LocalTime.parse("17:55:04.90512", dtf);
            p.query().execute(Tuple.tuple().addArrayOfLocalTime(new LocalTime[]{dt}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"LocalTime").returns(Tuple::getValue, Row::getValue, (Object[])new LocalTime[]{dt}).returns(Tuple::getArrayOfLocalTimes, Row::getArrayOfLocalTimes, (Object[])new LocalTime[]{dt}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeOffsetTimeArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: TIME WITH TIME ZONE [] \"OffsetTime\"", new OffsetTime[][]{{dt}}, Tuple::getArrayOfOffsetTimes);
    }

    @Test
    public void testEncodeOffsetTimeArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"OffsetTime\" = $1  WHERE \"id\" = $2 RETURNING \"OffsetTime\"", ctx.asyncAssertSuccess(p -> {
            OffsetTime dt = OffsetTime.parse("17:56:04.90512+03:07");
            p.query().execute(Tuple.tuple().addArrayOfOffsetTime(new OffsetTime[]{dt}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"OffsetTime").returns(Tuple::getValue, Row::getValue, (Object[])new OffsetTime[]{dt}).returns(Tuple::getArrayOfOffsetTimes, Row::getArrayOfOffsetTimes, (Object[])new OffsetTime[]{dt}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeLocalDateTimeArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: TIMESTAMP WITHOUT TIME ZONE [] \"LocalDateTime\"", new LocalDateTime[][]{{LocalDateTime.parse("2017-05-14T19:35:58.237666")}}, Tuple::getArrayOfLocalDateTimes);
    }

    @Test
    public void testEncodeLocalDateTimeArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"LocalDateTime\" = $1  WHERE \"id\" = $2 RETURNING \"LocalDateTime\"", ctx.asyncAssertSuccess(p -> {
            LocalDateTime dt = LocalDateTime.parse("2017-05-14T19:35:58.237666");
            p.query().execute(Tuple.tuple().addArrayOfLocalDateTime(new LocalDateTime[]{dt}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"LocalDateTime").returns(Tuple::getValue, Row::getValue, (Object[])new LocalDateTime[]{dt}).returns(Tuple::getArrayOfLocalTimes, Row::getArrayOfLocalTimes, (Object[])new LocalTime[]{dt.toLocalTime()}).returns(Tuple::getArrayOfLocalDates, Row::getArrayOfLocalDates, (Object[])new LocalDate[]{dt.toLocalDate()}).returns(Tuple::getArrayOfLocalDateTimes, Row::getArrayOfLocalDateTimes, (Object[])new LocalDateTime[]{dt}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeOffsetDateTimeArray(TestContext ctx) {
        this.testGeneric(ctx, "SELECT $1 :: TIMESTAMP WITH TIME ZONE [] \"OffsetDateTime\"", new OffsetDateTime[][]{{odt}}, Tuple::getArrayOfOffsetDateTimes);
    }

    @Test
    public void testEncodeOffsetDateTimeArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"OffsetDateTime\" = $1  WHERE \"id\" = $2 RETURNING \"OffsetDateTime\"", ctx.asyncAssertSuccess(p -> {
            OffsetDateTime dt = OffsetDateTime.parse("2017-05-14T19:35:58.237666Z");
            p.query().execute(Tuple.tuple().addArrayOfOffsetDateTime(new OffsetDateTime[]{dt}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"OffsetDateTime").returns(Tuple::getValue, Row::getValue, (Object[])new OffsetDateTime[]{dt}).returns(Tuple::getArrayOfOffsetTimes, Row::getArrayOfOffsetTimes, (Object[])new OffsetTime[]{dt.toOffsetTime()}).returns(Tuple::getArrayOfOffsetDateTimes, Row::getArrayOfOffsetDateTimes, (Object[])new OffsetDateTime[]{dt}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeIntervalArray(TestContext ctx) {
        this.testGenericArray(ctx, "SELECT $1 :: INTERVAL [] \"Interval\"", new Interval[][]{intervals}, Interval.class);
    }

    @Test
    public void testEncodeIntervalArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Interval\" = $1  WHERE \"id\" = $2 RETURNING \"Interval\"", ctx.asyncAssertSuccess(p -> {
            Interval[] intervals = new Interval[]{Interval.of().years(10).months(3).days(332).hours(20).minutes(20).seconds(20).microseconds(999991), Interval.of().minutes(20).seconds(20).microseconds(123456), Interval.of().years(-2).months(-6), Interval.of()};
            p.query().execute(Tuple.tuple().addValue((Object)intervals).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"Interval").returns(Tuple::getValue, Row::getValue, (Object[])intervals).returns(Interval.class, (Object[])intervals).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }

    private <T> void testDecodeDataTimeGeneric(TestContext ctx, String dataType, String columnName, ColumnChecker.SerializableBiFunction<Tuple, Integer, T> byIndexGetter, ColumnChecker.SerializableBiFunction<Row, String, T> byNameGetter, T expected) {
        this.testDecodeDataTimeGeneric(ctx, dataType, columnName, ColumnChecker.checkColumn((int)0, (String)columnName).returns(Tuple::getValue, Row::getValue, expected).returns(byIndexGetter, byNameGetter, expected).returns(Tuple::getTemporal, Row::getTemporal, expected), expected);
    }

    private <T> void testDecodeDataTimeGeneric(TestContext ctx, String dataType, String columnName, ColumnChecker checker, T expected) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT $1 :: " + dataType + " \"" + columnName + "\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addValue(expected), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            checker.forRow(row);
            async.complete();
        }))))));
    }
}

