/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DataTypeCodecTest {
    @Test
    public void testDecodeTextArray() {
        this.assertTextArray("{foo}", "foo");
        this.assertTextArray("{foo,bar}", "foo", "bar");
        this.assertTextArray("{\"foo\",bar}", "foo", "bar");
        this.assertTextArray("{foo,\"bar\"}", "foo", "bar");
        this.assertTextArray("{foo,\"ba\\\"r\"}", "foo", "ba\"r");
        this.assertTextArray("{foo,\"bar\\\"\"}", "foo", "bar\"");
        this.assertTextArray("{foo,\"bar\\\\\"}", "foo", "bar\\");
    }

    private void assertTextArray(String data, String ... expected) {
        ByteBuf buff = Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8);
        List<String> res = Arrays.asList((String[])DataTypeCodec.decodeText((DataType)DataType.TEXT_ARRAY, (int)0, (int)buff.readableBytes(), (ByteBuf)buff));
        Assert.assertEquals(Arrays.asList(expected), res);
    }
}

