/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.data.SimpleQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.io.Serializable;
import org.junit.Test;

public class CharacterTypesSimpleCodecTest
extends SimpleQueryDataTypeCodecTestBase {
    @Test
    public void testName(TestContext ctx) {
        this.testDecodeGeneric(ctx, "VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X & VERT.X", "NAME", "Name", Tuple::getString, Row::getString, "VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X VERT.X ");
    }

    @Test
    public void testBlankPaddedChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "pgClient", "CHAR(15)", "Char", Tuple::getString, Row::getString, "pgClient       ");
    }

    @Test
    public void testSingleBlankPaddedChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "V", "CHAR", "Char", Tuple::getString, Row::getString, "V");
    }

    @Test
    public void testSingleChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "X", "CHAR", "Character", Tuple::getString, Row::getString, "X");
    }

    @Test
    public void testVarChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "pgClient", "VARCHAR(15)", "Driver", Tuple::getString, Row::getString, "pgClient");
    }

    @Test
    public void testText(TestContext ctx) {
        this.testDecodeGeneric(ctx, "Vert.x PostgreSQL Client", "TEXT", "Text", Tuple::getString, Row::getString, "Vert.x PostgreSQL Client");
    }

    @Test
    public void testDecodeCHARArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY['01234567' :: CHAR(8)]", "CharArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfStrings), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfStrings), "01234567");
    }

    @Test
    public void testDecodeTEXTArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['Knock, knock.Who\u2019s there?very long pause\u2026.Java.' :: TEXT]", "TextArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfStrings), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfStrings), "Knock, knock.Who\u2019s there?very long pause\u2026.Java.");
    }

    @Test
    public void testDecodeTEXTArray2(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['foo' :: TEXT, 'bar\\' :: TEXT]", "TextArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfStrings), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfStrings), "foo", "bar\\");
    }

    @Test
    public void testDecodeVARCHARArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['Knock, knock.Who\u2019s there?very long pause\u2026.Java.' :: VARCHAR]", "VarcharArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfStrings), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfStrings), "Knock, knock.Who\u2019s there?very long pause\u2026.Java.");
    }

    @Test
    public void testDecodeNAMEArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY ['Knock, knock.Who\u2019s there?very long pause\u2026.Java.' :: NAME]", "NameArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfStrings), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfStrings), "Knock, knock.Who\u2019s there?very long pause\u2026.Java.");
    }
}

