/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.data.SimpleQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.io.Serializable;
import org.junit.Test;

public class BinaryDataTypesSimpleCodecTest
extends SimpleQueryDataTypeCodecTestBase {
    @Test
    public void testByteaHexFormat1(TestContext ctx) {
        this.testDecodeGeneric(ctx, "12345678910", "BYTEA", "Buffer1", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((String)"12345678910"));
    }

    @Test
    public void testByteaHexFormat2(TestContext ctx) {
        this.testDecodeGeneric(ctx, "\u00de\u00ad\u00be\u00ef", "BYTEA", "Buffer2", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((String)"\u00de\u00ad\u00be\u00ef"));
    }

    @Test
    public void testByteaEscapeBackslash(TestContext ctx) {
        this.testDecodeGeneric(ctx, "\\\\\\134", "BYTEA", "Buffer3", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{92, 92}));
    }

    @Test
    public void testByteaEscapeNonPrintableOctets(TestContext ctx) {
        this.testDecodeGeneric(ctx, "\\001\\007", "BYTEA", "Buffer4", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{1, 7}));
    }

    @Test
    public void testByteaEscapePrintableOctets(TestContext ctx) {
        this.testDecodeGeneric(ctx, "123abc", "BYTEA", "Buffer5", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{49, 50, 51, 97, 98, 99}));
    }

    @Test
    public void testByteaEscapeSingleQuote(TestContext ctx) {
        this.testDecodeGeneric(ctx, "''", "BYTEA", "Buffer6", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{39}));
    }

    @Test
    public void testByteaEscapeZeroOctet(TestContext ctx) {
        this.testDecodeGeneric(ctx, "\\000", "BYTEA", "Buffer7", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{0}));
    }

    @Test
    public void testByteaEscapeFormat(TestContext ctx) {
        this.testDecodeGeneric(ctx, "abc \\153\\154\\155 \\052\\251\\124", "BYTEA", "Buffer8", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((byte[])new byte[]{97, 98, 99, 32, 107, 108, 109, 32, 42, -87, 84}));
    }

    @Test
    public void testByteaEmptyString(TestContext ctx) {
        this.testDecodeGeneric(ctx, "", "BYTEA", "Buffer9", Tuple::getBuffer, Row::getBuffer, Buffer.buffer((String)""));
    }

    @Test
    public void testDecodeHexByteaArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY [decode('48454c4c4f', 'hex') :: BYTEA]", "BufferArray", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfBuffers), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfBuffers), Buffer.buffer((String)"HELLO"));
    }

    @Test
    public void testDecodeEscapeByteaArray(TestContext ctx) {
        this.testDecodeGenericArray(ctx, "ARRAY [decode('abc \\153\\154\\155 \\052\\251\\124', 'escape') :: BYTEA]", "BufferArray2", (ColumnChecker.SerializableBiFunction<Tuple, Integer, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Tuple::getArrayOfBuffers), (ColumnChecker.SerializableBiFunction<Row, String, Object>)((ColumnChecker.SerializableBiFunction & Serializable)Row::getArrayOfBuffers), Buffer.buffer((byte[])new byte[]{97, 98, 99, 32, 107, 108, 109, 32, 42, -87, 84}));
    }
}

