/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.context;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.PgTestBase;
import io.vertx.sqlclient.PoolOptions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class ContextTest
extends PgTestBase {
    protected Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected abstract Context createContext();

    @Test
    public void testConnection(TestContext testCtx) {
        Async async = testCtx.async();
        Context connCtx = this.createContext();
        connCtx.runOnContext(v1 -> PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)testCtx.asyncAssertSuccess(conn -> {
            testCtx.assertEquals((Object)connCtx, (Object)Vertx.currentContext());
            conn.query("SELECT *  FROM (VALUES ('Hello world')) t1 (col1) WHERE 1 = 1").execute(testCtx.asyncAssertSuccess(result -> {
                testCtx.assertEquals((Object)connCtx, (Object)Vertx.currentContext());
                async.complete();
            }));
        })));
    }

    @Test
    public void testPooledConnection(TestContext testCtx) {
        Context appCtx = this.createContext();
        Async async = testCtx.async();
        Context connCtx = this.vertx.getOrCreateContext();
        connCtx.runOnContext(v1 -> {
            PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)this.options, (PoolOptions)new PoolOptions());
            appCtx.runOnContext(v -> pool.getConnection(testCtx.asyncAssertSuccess(conn -> {
                testCtx.assertEquals((Object)appCtx, (Object)Vertx.currentContext());
                conn.query("SELECT *  FROM (VALUES ('Hello world')) t1 (col1) WHERE 1 = 1").execute(testCtx.asyncAssertSuccess(result -> {
                    testCtx.assertEquals((Object)appCtx, (Object)Vertx.currentContext());
                    async.complete();
                }));
            })));
        });
    }

    @Test
    public void testPoolQuery(TestContext testCtx) {
        Context appCtx = this.createContext();
        Async async = testCtx.async();
        Context connCtx = this.vertx.getOrCreateContext();
        connCtx.runOnContext(v1 -> {
            PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)this.options, (PoolOptions)new PoolOptions());
            appCtx.runOnContext(v -> pool.query("SELECT *  FROM (VALUES ('Hello world')) t1 (col1) WHERE 1 = 1").execute(testCtx.asyncAssertSuccess(result -> {
                testCtx.assertEquals((Object)appCtx, (Object)Vertx.currentContext());
                async.complete();
            })));
        });
    }
}

