/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.vertx.core.buffer.Buffer;
import io.vertx.pgclient.impl.util.UTF8StringEndDetector;
import io.vertx.pgclient.impl.util.Util;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testWriteHexString() {
        UtilTest.assertWriteHexString("00", 0);
        UtilTest.assertWriteHexString("01", 1);
        UtilTest.assertWriteHexString("0a", 10);
        UtilTest.assertWriteHexString("10", 16);
        UtilTest.assertWriteHexString("ff", -1);
        UtilTest.assertWriteHexString("ff0a0a", -1, 10, 10);
        Buffer buff = Buffer.buffer();
        for (int i = 0; i < 512; ++i) {
            buff.appendByte((byte)(65 + i % 26));
        }
    }

    private static void assertWriteHexString(String expected, byte ... data) {
        ByteBuf buff = Unpooled.buffer();
        Util.writeHexString((Buffer)Buffer.buffer().appendBytes(data), (ByteBuf)buff);
        String hex = buff.toString(StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expected, (Object)hex);
    }

    @Test
    public void testUTF8StringEndDetector() throws Exception {
        this.assertSeparator("", -1);
        this.assertSeparator("\"", -1);
        this.assertSeparator("\"\"", 1);
        this.assertSeparator("\"a\"", 2);
        this.assertSeparator("\"\u20ac\"", 4);
        this.assertSeparator("\"\\\"\"", 3);
    }

    private void assertSeparator(String s, int expected) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
        UTF8StringEndDetector processor = new UTF8StringEndDetector();
        int actual = buf.forEachByte((ByteProcessor)processor);
        Assert.assertEquals((long)expected, (long)actual);
    }
}

