/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.junit.PgRule;
import io.vertx.sqlclient.PoolOptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class UnixDomainSocketTest {
    private static final String unixSocketDirectory = System.getProperty("unix.socket.directory");
    private static final String unixSocketPort = System.getProperty("unix.socket.port");
    private static final boolean nativeTransportEnabled;
    @ClassRule
    public static PgRule rule;
    private PgPool client;
    private PgConnectOptions options;

    @Before
    public void before() {
        this.options = rule.options();
        if (unixSocketDirectory != null && !unixSocketDirectory.isEmpty()) {
            this.options.setHost(unixSocketDirectory);
        }
        if (unixSocketPort != null && !unixSocketPort.isEmpty()) {
            this.options.setPort(Integer.parseInt(unixSocketPort));
        }
    }

    @After
    public void after(TestContext ctx) {
        if (this.client != null) {
            this.client.close(ctx.asyncAssertSuccess());
        }
    }

    @Test
    public void uriTest(TestContext context) {
        Assume.assumeTrue((boolean)this.options.isUsingDomainSocket());
        String uri = "postgresql://postgres:postgres@/postgres?host=" + this.options.getHost() + "&port=" + this.options.getPort();
        this.client = PgPool.pool((String)uri);
        this.client.getConnection(context.asyncAssertSuccess(pgConnection -> pgConnection.close()));
    }

    @Test
    public void simpleConnect(TestContext context) {
        Assume.assumeTrue((boolean)this.options.isUsingDomainSocket());
        this.client = PgPool.pool((PgConnectOptions)new PgConnectOptions(this.options), (PoolOptions)new PoolOptions());
        this.client.getConnection(context.asyncAssertSuccess(pgConnection -> pgConnection.close(context.asyncAssertSuccess())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectWithVertxInstance(TestContext context) {
        Assume.assumeTrue((boolean)this.options.isUsingDomainSocket());
        try (Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));){
            this.client = PgPool.pool((Vertx)vertx, (PgConnectOptions)new PgConnectOptions(this.options), (PoolOptions)new PoolOptions());
            Async async = context.async();
            this.client.getConnection(context.asyncAssertSuccess(pgConnection -> {
                async.complete();
                pgConnection.close();
            }));
            async.await();
        }
    }

    @Test
    public void testIgnoreSslMode(TestContext context) {
        Assume.assumeTrue((boolean)this.options.isUsingDomainSocket());
        this.client = PgPool.pool((PgConnectOptions)new PgConnectOptions(this.options).setSslMode(SslMode.REQUIRE), (PoolOptions)new PoolOptions());
        this.client.getConnection(context.asyncAssertSuccess(pgConnection -> {
            Assert.assertFalse((boolean)pgConnection.isSSL());
            pgConnection.close();
        }));
    }

    static {
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));
        nativeTransportEnabled = vertx.isNativeTransportEnabled();
        vertx.close();
        rule = new PgRule().domainSockets(nativeTransportEnabled);
    }
}

