/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.Row;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RowTest
extends PgTestBase {
    Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    private static <T> Function<String, T> accessor(Row row, Class<T> type) {
        return name -> {
            int idx = row.getColumnIndex(name);
            if (idx == -1) {
                throw new NoSuchElementException();
            }
            return row.get(type, idx);
        };
    }

    private static <T> Function<String, T[]> arrayAccessor(Row row, Class<T> type) {
        return name -> {
            int idx = row.getColumnIndex(name);
            if (idx == -1) {
                throw new NoSuchElementException();
            }
            return (Object[])row.get(Array.newInstance(type, 0).getClass(), idx);
        };
    }

    @Test
    public void testGetNonExistingRows(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 1 \"foo\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            Function[] functionArray = new Function[49];
            functionArray[0] = arg_0 -> ((Row)row).getValue(arg_0);
            functionArray[1] = arg_0 -> ((Row)row).getShort(arg_0);
            functionArray[2] = arg_0 -> ((Row)row).getInteger(arg_0);
            functionArray[3] = arg_0 -> ((Row)row).getLong(arg_0);
            functionArray[4] = arg_0 -> ((Row)row).getFloat(arg_0);
            functionArray[5] = arg_0 -> ((Row)row).getDouble(arg_0);
            functionArray[6] = arg_0 -> ((Row)row).getBigDecimal(arg_0);
            functionArray[7] = arg_0 -> ((Row)row).getNumeric(arg_0);
            functionArray[8] = arg_0 -> ((Row)row).getString(arg_0);
            functionArray[9] = arg_0 -> ((Row)row).getBuffer(arg_0);
            functionArray[10] = arg_0 -> ((Row)row).getLocalDate(arg_0);
            functionArray[11] = arg_0 -> ((Row)row).getLocalTime(arg_0);
            functionArray[12] = arg_0 -> ((Row)row).getOffsetDateTime(arg_0);
            functionArray[13] = arg_0 -> ((Row)row).getLocalDateTime(arg_0);
            functionArray[14] = arg_0 -> ((Row)row).getOffsetTime(arg_0);
            functionArray[15] = arg_0 -> ((Row)row).getTemporal(arg_0);
            functionArray[16] = arg_0 -> ((Row)row).getUUID(arg_0);
            functionArray[17] = RowTest.accessor(row, Point.class);
            functionArray[18] = RowTest.accessor(row, Line.class);
            functionArray[19] = RowTest.accessor(row, LineSegment.class);
            functionArray[20] = RowTest.accessor(row, Box.class);
            functionArray[21] = RowTest.accessor(row, Path.class);
            functionArray[22] = RowTest.accessor(row, Polygon.class);
            functionArray[23] = RowTest.accessor(row, Circle.class);
            functionArray[24] = RowTest.accessor(row, Interval.class);
            functionArray[25] = arg_0 -> ((Row)row).getArrayOfShorts(arg_0);
            functionArray[26] = arg_0 -> ((Row)row).getArrayOfIntegers(arg_0);
            functionArray[27] = arg_0 -> ((Row)row).getArrayOfLongs(arg_0);
            functionArray[28] = arg_0 -> ((Row)row).getArrayOfFloats(arg_0);
            functionArray[29] = arg_0 -> ((Row)row).getArrayOfDoubles(arg_0);
            functionArray[30] = arg_0 -> ((Row)row).getArrayOfBigDecimals(arg_0);
            functionArray[31] = arg_0 -> ((Row)row).getArrayOfNumerics(arg_0);
            functionArray[32] = arg_0 -> ((Row)row).getArrayOfStrings(arg_0);
            functionArray[33] = arg_0 -> ((Row)row).getArrayOfBuffers(arg_0);
            functionArray[34] = arg_0 -> ((Row)row).getArrayOfLocalDates(arg_0);
            functionArray[35] = arg_0 -> ((Row)row).getArrayOfLocalTimes(arg_0);
            functionArray[36] = arg_0 -> ((Row)row).getArrayOfOffsetDateTimes(arg_0);
            functionArray[37] = arg_0 -> ((Row)row).getArrayOfLocalDateTimes(arg_0);
            functionArray[38] = arg_0 -> ((Row)row).getArrayOfOffsetTimes(arg_0);
            functionArray[39] = arg_0 -> ((Row)row).getArrayOfTemporals(arg_0);
            functionArray[40] = arg_0 -> ((Row)row).getArrayOfUUIDs(arg_0);
            functionArray[41] = RowTest.arrayAccessor(row, Point.class);
            functionArray[42] = RowTest.arrayAccessor(row, Line.class);
            functionArray[43] = RowTest.arrayAccessor(row, LineSegment.class);
            functionArray[44] = RowTest.arrayAccessor(row, Box.class);
            functionArray[45] = RowTest.arrayAccessor(row, Path.class);
            functionArray[46] = RowTest.arrayAccessor(row, Polygon.class);
            functionArray[47] = RowTest.arrayAccessor(row, Circle.class);
            functionArray[48] = RowTest.arrayAccessor(row, Interval.class);
            List<Function> functions = Arrays.asList(functionArray);
            functions.forEach(f -> {
                try {
                    f.apply("bar");
                    ctx.fail("Was expecting an NSEE");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                try {
                    f.apply(null);
                    ctx.fail("Was expecting an NPE");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            });
            async.complete();
        }))));
    }

    @Test
    public void testGetColumnNameRows(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 2 \"foo\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)"foo", (Object)row.getColumnName(0));
            async.complete();
        }))));
    }

    @Test
    public void testNotEqualGetColumnNameRows(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 2 \"foo\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertNotEquals((Object)"bar", (Object)row.getColumnName(0));
            async.complete();
        }))));
    }

    @Test
    public void testNegativeGetColumnNameRows(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 2 \"foo\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertNull((Object)row.getColumnName(-1));
            async.complete();
        }))));
    }

    @Test
    public void testPreventLengthMaxIndexOutOfBoundGetColumnNameRows(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 2 \"foo\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            ctx.assertNull((Object)row.getColumnName(1));
            async.complete();
        }))));
    }

    @Test
    public void testToJsonObject(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 2::smallint \"small_int\",2::integer \"integer\",2::bigint \"bigint\",2::real \"real\",2::double precision \"double\",'str' \"string\",true \"boolean\",'null'::json \"json_null\",'7'::json \"json_number\",'\"baz\"'::json \"json_string\",'false'::json \"json_boolean\",'{\"bar\": \"baz\", \"balance\": 7, \"active\": false}'::json \"json_object\",'[\"baz\",7,false]'::json \"json_array\",E'\\\\x010203'::bytea \"buffer\",'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11'::uuid \"uuid\",ARRAY[1, 2, 3] \"array\"").execute(ctx.asyncAssertSuccess(result -> {
            Row row = (Row)result.iterator().next();
            JsonObject json = row.toJson();
            ctx.assertEquals((Object)2, json.getValue("small_int"));
            ctx.assertEquals((Object)2, json.getValue("integer"));
            ctx.assertEquals((Object)2L, json.getValue("bigint"));
            ctx.assertEquals((Object)Float.valueOf(2.0f), json.getValue("real"));
            ctx.assertEquals((Object)2.0, json.getValue("double"));
            ctx.assertEquals((Object)"str", json.getValue("string"));
            ctx.assertEquals((Object)true, json.getValue("boolean"));
            ctx.assertEquals(null, json.getValue("json_null"));
            ctx.assertEquals((Object)7, json.getValue("json_number"));
            ctx.assertEquals((Object)"baz", json.getValue("json_string"));
            ctx.assertEquals((Object)false, json.getValue("json_boolean"));
            ctx.assertEquals((Object)new JsonObject().put("bar", (Object)"baz").put("balance", (Object)7).put("active", (Object)false), json.getValue("json_object"));
            ctx.assertEquals((Object)new JsonArray().add((Object)"baz").add((Object)7).add((Object)false), json.getValue("json_array"));
            ctx.assertEquals((Object)Buffer.buffer().appendByte((byte)1).appendByte((byte)2).appendByte((byte)3), json.getMap().get("buffer"));
            ctx.assertEquals((Object)new String(Base64.getEncoder().encode(new byte[]{1, 2, 3})), json.getValue("buffer"));
            ctx.assertEquals((Object)"a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11", json.getValue("uuid"));
            ctx.assertEquals((Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3), json.getValue("array"));
            async.complete();
        }))));
    }
}

