/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;

class ProxyServer {
    private final Vertx vertx;
    private final NetServer server;
    private final NetClient client;
    private final int pgPort;
    private final String pgHost;
    private Handler<Connection> proxyHandler;

    static ProxyServer create(Vertx vertx, int pgPort, String pgHost) {
        return new ProxyServer(vertx, pgPort, pgHost);
    }

    private ProxyServer(Vertx vertx, int pgPort, String pgHost) {
        this.pgPort = pgPort;
        this.pgHost = pgHost;
        this.vertx = vertx;
        this.client = vertx.createNetClient();
        this.server = vertx.createNetServer().connectHandler(this::handle);
        this.proxyHandler = Connection::connect;
    }

    public ProxyServer proxyHandler(Handler<Connection> proxyHandler) {
        this.proxyHandler = proxyHandler;
        return this;
    }

    public void listen(int port, String host, Handler<AsyncResult<Void>> completionHandler) {
        this.server.listen(port, host, ar -> completionHandler.handle((Object)ar.mapEmpty()));
    }

    private void handle(NetSocket clientSocket) {
        clientSocket.pause();
        this.client.connect(this.pgPort, this.pgHost, ar -> {
            if (ar.succeeded()) {
                NetSocket serverSocket = (NetSocket)ar.result();
                serverSocket.pause();
                Connection conn = new Connection(clientSocket, serverSocket);
                this.proxyHandler.handle((Object)conn);
            } else {
                clientSocket.close();
            }
        });
    }

    static class Connection {
        private final NetSocket clientSocket;
        private final NetSocket serverSocket;
        private Handler<Buffer> clientHandler;
        private Handler<Buffer> serverHandler;
        private Handler<Void> clientCloseHandler;
        private Handler<Void> serverCloseHandler;

        public Connection(NetSocket clientSo, NetSocket serverSo) {
            this.clientSocket = clientSo;
            this.serverSocket = serverSo;
            this.clientHandler = arg_0 -> ((NetSocket)this.serverSocket).write(arg_0);
            this.serverHandler = arg_0 -> ((NetSocket)this.clientSocket).write(arg_0);
        }

        NetSocket clientSocket() {
            return this.clientSocket;
        }

        NetSocket serverSocket() {
            return this.serverSocket;
        }

        Connection clientHandler(Handler<Buffer> handler) {
            this.clientHandler = handler;
            return this;
        }

        Connection serverHandler(Handler<Buffer> handler) {
            this.serverHandler = handler;
            return this;
        }

        void connect() {
            this.clientSocket.handler(this.clientHandler);
            this.serverSocket.handler(this.serverHandler);
            this.clientSocket.closeHandler(v -> {
                this.serverSocket.close();
                if (this.clientCloseHandler != null) {
                    this.clientCloseHandler.handle(null);
                }
            });
            this.serverSocket.closeHandler(v -> {
                this.clientSocket.close();
                if (this.serverCloseHandler != null) {
                    this.serverCloseHandler.handle(null);
                }
            });
            this.serverSocket.resume();
            this.clientSocket.resume();
        }

        Connection clientCloseHandler(Handler<Void> handler) {
            this.clientCloseHandler = handler;
            return this;
        }

        Connection serverCloseHandler(Handler<Void> handler) {
            this.serverCloseHandler = handler;
            return this;
        }

        void close() {
            this.clientSocket.close();
            this.serverSocket.close();
        }
    }
}

