/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.junit.ContainerPgRule;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class PoolMultiTest {
    @ClassRule
    public static final ContainerPgRule db1 = new ContainerPgRule().user("user1");
    @ClassRule
    public static final ContainerPgRule db2 = new ContainerPgRule().user("user2");
    private Vertx vertx;

    @Before
    public void setup() throws Exception {
        this.vertx = Vertx.vertx();
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testListLoadBalancing(TestContext ctx) {
        this.testLoadBalancing(ctx, PgPool.pool((Vertx)this.vertx, Arrays.asList(db1.options(), db2.options()), (PoolOptions)new PoolOptions().setMaxSize(5)));
    }

    @Test
    public void testAsyncLoadBalancing(TestContext ctx) {
        PgPool pool = PgPool.pool((Vertx)this.vertx, (PoolOptions)new PoolOptions().setMaxSize(5));
        final ConnectionFactory provider1 = PgDriver.INSTANCE.createConnectionFactory(this.vertx, (SqlConnectOptions)db1.options());
        final ConnectionFactory provider2 = PgDriver.INSTANCE.createConnectionFactory(this.vertx, (SqlConnectOptions)db2.options());
        pool.connectionProvider((Function)new Function<Context, Future<SqlConnection>>(){
            int idx = 0;

            @Override
            public Future<SqlConnection> apply(Context context) {
                return (this.idx++ % 2 == 0 ? provider1 : provider2).connect(context);
            }
        });
        this.testLoadBalancing(ctx, pool);
    }

    private void testLoadBalancing(TestContext ctx, PgPool pool) {
        int count = 5;
        Async async = ctx.async(count);
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < count; ++i) {
            futures.add(pool.getConnection());
        }
        List users = Collections.synchronizedList(new ArrayList());
        CompositeFuture.all(futures).onComplete(ctx.asyncAssertSuccess(c -> {
            for (int i = 0; i < count; ++i) {
                SqlConnection conn = (SqlConnection)((Future)futures.get(i)).result();
                conn.query("SELECT user").execute(ctx.asyncAssertSuccess(res -> {
                    users.add(((Row)res.iterator().next()).getString(0));
                    conn.close(ctx.asyncAssertSuccess(v -> async.countDown()));
                }));
            }
        }));
        async.awaitSuccess(20000L);
        Assert.assertEquals((long)5L, (long)users.size());
        Assert.assertEquals((long)3L, (long)users.stream().filter("user1"::equals).count());
        Assert.assertEquals((long)2L, (long)users.stream().filter("user2"::equals).count());
    }
}

