/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.ProxyServer;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PgPoolTestBase
extends PgTestBase {
    Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected PgPool createPool(PgConnectOptions connectOptions, int size) {
        return this.createPool(connectOptions, new PoolOptions().setMaxSize(size));
    }

    protected abstract PgPool createPool(PgConnectOptions var1, PoolOptions var2);

    @Test
    public void testPool(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        PgPool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, randomnumber from WORLD").execute(ar -> {
                if (ar.succeeded()) {
                    SqlResult result = (SqlResult)ar.result();
                    ctx.assertEquals((Object)10000, (Object)result.size());
                } else {
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                conn.close();
                async.countDown();
            })));
        }
    }

    @Test
    public void testQuery(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        PgPool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.query("SELECT id, randomnumber from WORLD").execute(ar -> {
                if (ar.succeeded()) {
                    SqlResult result = (SqlResult)ar.result();
                    ctx.assertEquals((Object)10000, (Object)result.size());
                } else {
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                async.countDown();
            });
        }
    }

    @Test
    public void testQueryWithParams(TestContext ctx) {
        this.testQueryWithParams(ctx, this.options);
    }

    @Test
    public void testCachedQueryWithParams(TestContext ctx) {
        this.testQueryWithParams(ctx, new PgConnectOptions(this.options).setCachePreparedStatements(true));
    }

    private void testQueryWithParams(TestContext ctx, PgConnectOptions options) {
        int num = 2;
        Async async = ctx.async(num);
        PgPool pool = this.createPool(options, 1);
        for (int i = 0; i < num; ++i) {
            pool.preparedQuery("SELECT id, randomnumber from WORLD where id=$1").execute(Tuple.of((Object)(i + 1)), ar -> {
                if (ar.succeeded()) {
                    SqlResult result = (SqlResult)ar.result();
                    ctx.assertEquals((Object)1, (Object)result.size());
                } else {
                    ar.cause().printStackTrace();
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                async.countDown();
            });
        }
    }

    @Test
    public void testUpdate(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        PgPool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.query("UPDATE Fortune SET message = 'Whatever' WHERE id = 9").execute(ar -> {
                if (ar.succeeded()) {
                    SqlResult result = (SqlResult)ar.result();
                    ctx.assertEquals((Object)1, (Object)result.rowCount());
                } else {
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                async.countDown();
            });
        }
    }

    @Test
    public void testUpdateWithParams(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        PgPool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.preparedQuery("UPDATE Fortune SET message = 'Whatever' WHERE id = $1").execute(Tuple.of((Object)9), ar -> {
                if (ar.succeeded()) {
                    SqlResult result = (SqlResult)ar.result();
                    ctx.assertEquals((Object)1, (Object)result.rowCount());
                } else {
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                async.countDown();
            });
        }
    }

    @Test
    public void testReconnect(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            conn.connect();
        }));
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> {
            PgPool pool = this.createPool(new PgConnectOptions(this.options).setPort(8080).setHost("localhost"), 1);
            pool.getConnection(ctx.asyncAssertSuccess(conn1 -> {
                ((ProxyServer.Connection)proxyConn.get()).close();
                conn1.closeHandler(v2 -> conn1.query("never-read").execute(ctx.asyncAssertFailure(err -> pool.getConnection(ctx.asyncAssertSuccess(conn2 -> conn2.query("SELECT id, randomnumber from WORLD").execute(ctx.asyncAssertSuccess(v3 -> async.complete())))))));
            }));
        }));
    }

    @Test
    public void testCancelRequest(TestContext ctx) {
        Async async = ctx.async();
        PgPool pool = this.createPool(this.options, 4);
        pool.getConnection(ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT pg_sleep(10)").execute(ctx.asyncAssertFailure(error -> {
                ctx.assertTrue(PgPoolTestBase.hasSqlstateCode(error, "57014"), error.getMessage());
                conn.close();
                async.complete();
            }));
            ((PgConnection)conn).cancelRequest(ctx.asyncAssertSuccess());
        }));
    }

    @Test
    public void testWithConnection(TestContext ctx) {
        Async async = ctx.async(10);
        PgPool pool = this.createPool(this.options, 1);
        Function<SqlConnection, Future> success = conn -> conn.query("SELECT 1").execute();
        Function<SqlConnection, Future> failure = conn -> conn.query("SELECT does_not_exist").execute();
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                pool.withConnection(success, ctx.asyncAssertSuccess(v -> async.countDown()));
                continue;
            }
            pool.withConnection(failure, ctx.asyncAssertFailure(v -> async.countDown()));
        }
    }
}

