/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.PgPoolTestBase;
import io.vertx.pgclient.ProxyServer;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.junit.Rule;
import org.junit.Test;

public class PgPoolTest
extends PgPoolTestBase {
    @Rule
    public RepeatRule rule = new RepeatRule();
    private Set<PgPool> pools = new HashSet<PgPool>();

    @Override
    public void tearDown(TestContext ctx) {
        int size = this.pools.size();
        if (size > 0) {
            Async async = ctx.async(size);
            Set<PgPool> pools = this.pools;
            this.pools = new HashSet<PgPool>();
            pools.forEach(pool -> pool.close(ar -> async.countDown()));
            async.awaitSuccess(20000L);
        }
        super.tearDown(ctx);
    }

    @Override
    protected PgPool createPool(PgConnectOptions connectOptions, PoolOptions poolOptions) {
        PgPool pool = PgPool.pool((Vertx)this.vertx, (PgConnectOptions)connectOptions, (PoolOptions)poolOptions);
        this.pools.add(pool);
        return pool;
    }

    @Test
    public void testReconnectQueued(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            conn.connect();
        }));
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> {
            PgPool pool = this.createPool(new PgConnectOptions(this.options).setPort(8080).setHost("localhost"), 1);
            pool.getConnection(ctx.asyncAssertSuccess(conn -> ((ProxyServer.Connection)proxyConn.get()).close()));
            pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, randomnumber from WORLD").execute(ctx.asyncAssertSuccess(v2 -> async.complete()))));
        }));
    }

    @Test
    public void testAuthFailure(TestContext ctx) {
        Async async = ctx.async();
        PgPool pool = this.createPool(new PgConnectOptions(this.options).setPassword("wrong"), 1);
        pool.query("SELECT id, randomnumber from WORLD").execute(ctx.asyncAssertFailure(v2 -> async.complete()));
    }

    @Test
    public void testConnectionFailure(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            conn.connect();
        }));
        PgPool pool = this.createPool(new PgConnectOptions(this.options).setPort(8080).setHost("localhost"), new PoolOptions().setMaxSize(1).setMaxWaitQueueSize(0));
        pool.getConnection(ctx.asyncAssertFailure(err -> proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> pool.getConnection(ctx.asyncAssertSuccess(conn -> async.complete()))))));
    }

    @Test
    public void testRunWithExisting(TestContext ctx) {
        Async async = ctx.async();
        this.vertx.runOnContext(v -> {
            try {
                PgPool.pool((PoolOptions)new PoolOptions());
                ctx.fail();
            }
            catch (IllegalStateException ignore) {
                async.complete();
            }
        });
    }

    @Test
    public void testRunStandalone(TestContext ctx) {
        Async async = ctx.async();
        PgPool pool = this.createPool(new PgConnectOptions(this.options), new PoolOptions());
        pool.query("SELECT id, randomnumber from WORLD").execute(ctx.asyncAssertSuccess(v -> async.complete()));
        async.await(4000L);
    }

    @Test
    public void testMaxWaitQueueSize(TestContext ctx) {
        Async async = ctx.async();
        PgPool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1).setMaxWaitQueueSize(0));
        pool.getConnection(ctx.asyncAssertSuccess(v -> pool.getConnection(ctx.asyncAssertFailure(err -> async.complete()))));
        async.await(4000000L);
    }

    @Test
    public void testConcurrentMultipleConnection(TestContext ctx) {
        PgPool pool = this.createPool(new PgConnectOptions(this.options).setCachePreparedStatements(true), 2);
        int numRequests = 2;
        Async async = ctx.async(numRequests);
        for (int i = 0; i < numRequests; ++i) {
            pool.preparedQuery("SELECT * FROM Fortune WHERE id=$1").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
                ctx.assertEquals((Object)1, (Object)results.size());
                Tuple row = (Tuple)results.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                async.countDown();
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseAvailableResources(TestContext ctx) {
        int poolSize = 10;
        Async async = ctx.async(poolSize + 1);
        PgPool pool = PgPool.pool((PgConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(poolSize));
        AtomicReference ctrlConnRef = new AtomicReference();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(ctrlConn -> {
            ctrlConnRef.set(ctrlConn);
            for (int i = 0; i < poolSize; ++i) {
                this.vertx.setTimer((long)(10 * (i + 1)), l -> pool.query("select pg_sleep(5)").execute(ctx.asyncAssertSuccess(res -> async.countDown())));
            }
            this.vertx.setTimer((long)(10 * poolSize + 50), event -> ctrlConn.query("select count(*) as cnt from pg_stat_activity where application_name like '%vertx%'").execute(ctx.asyncAssertSuccess(rows -> {
                Integer count = ((Row)rows.iterator().next()).getInteger("cnt");
                ctx.assertEquals((Object)(poolSize + 1), (Object)count);
                async.countDown();
            })));
        }));
        try {
            async.await();
        }
        finally {
            PgConnection ctrlConn2 = (PgConnection)ctrlConnRef.get();
            if (ctrlConn2 != null) {
                ctrlConn2.close();
            }
            pool.close();
        }
    }

    @Test
    public void testPipelining(TestContext ctx) {
        AtomicLong latency = new AtomicLong(0L);
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            conn.clientHandler((Handler<Buffer>)((Handler)buff -> {
                long delay = latency.get();
                if (delay == 0L) {
                    conn.serverSocket().write(buff);
                } else {
                    this.vertx.setTimer(delay, id -> conn.serverSocket().write(buff));
                }
            }));
            conn.connect();
        }));
        Async latch = ctx.async();
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(res -> latch.complete()));
        latch.awaitSuccess(20000L);
        this.options.setPort(8080);
        this.options.setHost("localhost");
        int num = 3;
        Async async = ctx.async(num);
        SqlClient pool = PgPool.client((PgConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(1));
        AtomicLong start = new AtomicLong();
        pool.query("select 1").execute(ctx.asyncAssertSuccess(res1 -> {
            start.set(System.currentTimeMillis());
            latency.set(1000L);
            for (int i = 0; i < num; ++i) {
                pool.query("select 1").execute(ctx.asyncAssertSuccess(res2 -> async.countDown()));
            }
        }));
        async.awaitSuccess(20000L);
        long elapsed = System.currentTimeMillis() - start.get();
        ctx.assertTrue(elapsed < 2000L, "Was expecting pipelined latency " + elapsed + " < 2000");
    }

    @Test
    public void testPoolIdleTimeout(TestContext ctx) {
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        int pooleCleanerPeriod = 100;
        int idleTimeout = 3000;
        Async latch = ctx.async();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            long now = System.currentTimeMillis();
            conn.clientCloseHandler((Handler<Void>)((Handler)v -> {
                long lifetime = System.currentTimeMillis() - now;
                int delta = 500;
                int lowerBound = idleTimeout - pooleCleanerPeriod - delta;
                int upperBound = idleTimeout + pooleCleanerPeriod + delta;
                ctx.assertTrue(lifetime >= (long)lowerBound, "Was expecting connection to be closed in more than " + lowerBound + ": " + lifetime);
                ctx.assertTrue(lifetime <= (long)upperBound, "Was expecting connection to be closed in less than " + upperBound + ": " + lifetime);
                latch.complete();
            }));
            conn.connect();
        }));
        Async listenLatch = ctx.async();
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(res -> listenLatch.complete()));
        listenLatch.awaitSuccess(20000L);
        this.poolOptions.setPoolCleanerPeriod(pooleCleanerPeriod).setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        this.options.setPort(8080);
        this.options.setHost("localhost");
        PgPool pool = this.createPool(this.options, this.poolOptions);
        pool.getConnection().flatMap(SqlClient::close).onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void testPoolConnectTimeout(TestContext ctx) {
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {}));
        Async listenLatch = ctx.async();
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(res -> listenLatch.complete()));
        listenLatch.awaitSuccess(20000L);
        this.poolOptions.setConnectionTimeout(1).setConnectionTimeoutUnit(TimeUnit.SECONDS);
        this.options.setPort(8080);
        this.options.setHost("localhost");
        PgPool pool = this.createPool(this.options, this.poolOptions);
        long now = System.currentTimeMillis();
        pool.getConnection(ctx.asyncAssertFailure(err -> ctx.assertTrue(System.currentTimeMillis() - now > 900L)));
    }

    @Test
    @Repeat(value=50)
    public void testNoConnectionLeaks(TestContext ctx) {
        Async killConnections = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            Collector collector = Collectors.mapping(row -> row.getInteger(0), Collectors.toList());
            String sql = "SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE pid <> pg_backend_pid() AND datname = $1";
            PreparedQuery preparedQuery = conn.preparedQuery(sql).collecting(collector);
            Tuple params = Tuple.of((Object)this.options.getDatabase());
            preparedQuery.execute(params).compose(cf -> conn.close()).onComplete(ctx.asyncAssertSuccess(v -> killConnections.complete()));
        }));
        killConnections.awaitSuccess();
        String sql = "SELECT pg_backend_pid() AS pid, (SELECT count(*) FROM pg_stat_activity WHERE application_name LIKE '%vertx%') AS cnt";
        int idleTimeout = 50;
        this.poolOptions.setMaxSize(1).setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setPoolCleanerPeriod(5);
        PgPool pool = this.createPool(this.options, this.poolOptions);
        Async async = ctx.async();
        AtomicInteger pid = new AtomicInteger();
        this.vertx.getOrCreateContext().runOnContext(v -> pool.query(sql).execute(ctx.asyncAssertSuccess(rs1 -> {
            Row row1 = (Row)rs1.iterator().next();
            pid.set(row1.getInteger("pid"));
            ctx.assertEquals((Object)1, (Object)row1.getInteger("cnt"));
            this.vertx.setTimer((long)(2 * idleTimeout), l -> pool.query(sql).execute(ctx.asyncAssertSuccess(rs2 -> {
                Row row2 = (Row)rs2.iterator().next();
                ctx.assertEquals((Object)1, (Object)row2.getInteger("cnt"));
                ctx.assertNotEquals((Object)pid.get(), (Object)row2.getInteger("pid"));
                async.complete();
            })));
        })));
        async.awaitSuccess();
    }

    @Test
    public void testConnectionHook(TestContext ctx) {
        Async async = ctx.async();
        Handler hook = f -> this.vertx.setTimer(1000L, id -> f.close());
        PgPool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1)).connectHandler(hook);
        pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, randomnumber from WORLD").execute(ctx.asyncAssertSuccess(v2 -> async.complete()))));
    }

    @Test
    public void testConnectionClosedInHook(TestContext ctx) {
        Async async = ctx.async(2);
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            conn.connect();
        }));
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> {
            Handler hook = f -> {
                f.closeHandler(v -> async.countDown());
                ((ProxyServer.Connection)proxyConn.get()).close();
            };
            PgPool pool = this.createPool(new PgConnectOptions(this.options).setPort(8080).setHost("localhost"), new PoolOptions().setMaxSize(1)).connectHandler(hook);
            pool.getConnection(ctx.asyncAssertFailure(conn -> async.countDown()));
        }));
    }

    @Test
    public void testConnectionClosedInProvider1(TestContext ctx) {
        this.testConnectionClosedInProvider(ctx, true);
    }

    @Test
    public void testConnectionClosedInProvider2(TestContext ctx) {
        this.testConnectionClosedInProvider(ctx, false);
    }

    private void testConnectionClosedInProvider(TestContext ctx, boolean immediately) {
        Async async = ctx.async(2);
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            proxyConn.set(conn);
            conn.connect();
        }));
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> {
            PgConnectOptions options = new PgConnectOptions(this.options).setPort(8080).setHost("localhost");
            ConnectionFactory factory = PgDriver.INSTANCE.createConnectionFactory(this.vertx, (SqlConnectOptions)options);
            PgPool pool = this.createPool(options, new PoolOptions().setMaxSize(1));
            pool.connectionProvider(context -> {
                Future fut = factory.connect(context);
                if (immediately) {
                    return fut.map(conn -> {
                        conn.close();
                        return conn;
                    });
                }
                return fut.flatMap(conn -> conn.close().map(conn));
            });
            pool.getConnection(ctx.asyncAssertFailure(conn -> this.vertx.runOnContext(v -> {
                ctx.assertEquals((Object)0, (Object)pool.size());
                async.complete();
            })));
        }));
    }
}

