/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgTestBase;
import io.vertx.sqlclient.Tuple;
import java.util.function.BiConsumer;
import org.junit.Before;
import org.junit.Test;

public class PgPipeliningTest
extends PgTestBase {
    Vertx vertx;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @Test
    public void testPreparedStatementValidationFailure(TestContext ctx) {
        this.repeat(ctx, (conn, async) -> conn.preparedQuery("SELECT $1 :: VARCHAR").execute(Tuple.of((Object)3), ctx.asyncAssertFailure(err -> async.countDown())));
    }

    @Test
    public void testPrepareFailure(TestContext ctx) {
        this.repeat(ctx, (conn, async) -> conn.preparedQuery("invalid").execute(ctx.asyncAssertFailure(err -> async.countDown())));
    }

    public void repeat(TestContext ctx, BiConsumer<PgConnection, Async> operation) {
        int times = 128;
        Async async = ctx.async(times);
        PgConnectOptions options = new PgConnectOptions(this.options).setPipeliningLimit(1);
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)options, (Handler)ctx.asyncAssertSuccess(conn -> {
            for (int i = 0; i < times; ++i) {
                operation.accept((PgConnection)conn, async);
            }
        }));
    }
}

