/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.junit.ContainerPgRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class PgDatabaseMetadataTest {
    private Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void test1(TestContext ctx) throws Exception {
        this.test(ctx, "9.6.18", "9.6.18", 9, 6);
    }

    @Test
    public void test2(TestContext ctx) throws Exception {
        this.test(ctx, "12.3", "12.3 (Debian 12.3-1.pgdg100+1)", 12, 3);
    }

    @Test
    public void test3(TestContext ctx) throws Exception {
        this.test(ctx, "13-beta2", "13beta2 (Debian 13~beta2-1.pgdg100+1)", 13, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(TestContext ctx, String containerVersion, String expectedFull, int expectedMajor, int expectedMinor) throws Exception {
        ContainerPgRule rule = new ContainerPgRule();
        Async async = ctx.async();
        try {
            PgConnectOptions options = rule.startServer(containerVersion);
            PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)options, (Handler)ctx.asyncAssertSuccess(conn -> {
                ctx.assertEquals((Object)expectedFull, (Object)conn.databaseMetadata().fullVersion());
                ctx.assertEquals((Object)expectedMajor, (Object)conn.databaseMetadata().majorVersion());
                ctx.assertEquals((Object)expectedMinor, (Object)conn.databaseMetadata().minorVersion());
                async.complete();
            }));
            async.await(20000L);
        }
        finally {
            rule.stopServer();
        }
    }
}

