/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.PgTestBase;
import io.vertx.pgclient.ProxyServer;
import io.vertx.pgclient.SslMode;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.SqlClientInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PgClientTestBase<C extends SqlClient>
extends PgTestBase {
    protected Vertx vertx;
    protected Consumer<Handler<AsyncResult<C>>> connector;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testConnectNonSSLServer(TestContext ctx) {
        Async async = ctx.async();
        this.options.setSslMode(SslMode.REQUIRE).setTrustAll(true);
        this.connector.accept(ctx.asyncAssertFailure(err -> {
            ctx.assertEquals((Object)"Postgres Server does not handle SSL connection", (Object)err.getMessage());
            async.complete();
        }));
    }

    @Test
    public void testMultipleQuery(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message from FORTUNE LIMIT 1;SELECT message, id from FORTUNE LIMIT 1").execute(ctx.asyncAssertSuccess(result1 -> {
            ctx.assertEquals((Object)1, (Object)result1.size());
            ctx.assertEquals(Arrays.asList("id", "message"), (Object)result1.columnsNames());
            Tuple row1 = (Tuple)result1.iterator().next();
            ctx.assertTrue(row1.getValue(0) instanceof Integer);
            ctx.assertTrue(row1.getValue(1) instanceof String);
            RowSet result2 = result1.next();
            ctx.assertNotNull((Object)result2);
            ctx.assertEquals((Object)1, (Object)result2.size());
            ctx.assertEquals(Arrays.asList("message", "id"), (Object)result2.columnsNames());
            Tuple row2 = (Tuple)result2.iterator().next();
            ctx.assertTrue(row2.getValue(0) instanceof String);
            ctx.assertTrue(row2.getValue(1) instanceof Integer);
            ctx.assertNull((Object)result2.next());
            async.complete();
        }))));
    }

    @Test
    public void testInsertReturning(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(client -> PgClientTestBase.deleteFromTestTable(ctx, client, () -> client.preparedQuery("INSERT INTO Test (id, val) VALUES ($1, $2) RETURNING id").execute(Tuple.of((Object)14, (Object)"SomeMessage"), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)14, (Object)((Row)result.iterator().next()).getInteger("id"));
            async.complete();
        })))));
    }

    @Test
    public void testInsertReturningBatch(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(client -> PgClientTestBase.deleteFromTestTable(ctx, client, () -> {
            List<Tuple> batch = Arrays.asList(Tuple.of((Object)14, (Object)"SomeMessage1"), Tuple.of((Object)15, (Object)"SomeMessage2"));
            client.preparedQuery("INSERT INTO Test (id, val) VALUES ($1, $2) RETURNING id").executeBatch(batch, ctx.asyncAssertSuccess(r1 -> {
                ctx.assertEquals((Object)14, (Object)((Row)r1.iterator().next()).getInteger("id"));
                RowSet r2 = r1.next();
                ctx.assertEquals((Object)15, (Object)((Row)r2.iterator().next()).getInteger("id"));
                async.complete();
            }));
        })));
    }

    @Test
    public void testInsertReturningError(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(client -> PgClientTestBase.deleteFromTestTable(ctx, client, () -> client.preparedQuery("INSERT INTO Test (id, val) VALUES ($1, $2) RETURNING id").execute(Tuple.of((Object)15, (Object)"SomeMessage"), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)15, (Object)((Row)result.iterator().next()).getInteger("id"));
            client.preparedQuery("INSERT INTO Test (id, val) VALUES ($1, $2) RETURNING id").execute(Tuple.of((Object)15, (Object)"SomeMessage"), ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)"23505", (Object)((PgException)err).getCode());
                async.complete();
            }));
        })))));
    }

    @Test
    public void testDeleteReturningBatch(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(client -> PgClientTestBase.deleteFromTestTable(ctx, client, () -> {
            List<Tuple> batch = Arrays.asList(Tuple.of((Object)14, (Object)"SomeMessage1"), Tuple.of((Object)15, (Object)"SomeMessage2"));
            client.preparedQuery("INSERT INTO Test (id, val) VALUES ($1, $2)").executeBatch(batch).compose(res -> client.query("DELETE FROM Test RETURNING id").collecting(Collectors.toMap(row -> row.getInteger(0), row -> "whatever")).execute()).onComplete(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)2, (Object)res.size());
                ctx.assertEquals(new HashSet<Integer>(Arrays.asList(14, 15)), ((Map)res.value()).keySet());
                async.complete();
            }));
        })));
    }

    static int randomWorld() {
        return 1 + ThreadLocalRandom.current().nextInt(10000);
    }

    @Test
    public void testBatchSelect(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.tuple());
            batch.add(Tuple.tuple());
            conn.preparedQuery("SELECT count(id) FROM World").executeBatch(batch, ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)result.size(), (Object)result.next().size());
                async.complete();
            }));
        }));
    }

    @Test
    public void testDisconnectAbruptlyDuringStartup(TestContext ctx) {
        Async async = ctx.async();
        ProxyServer proxy = ProxyServer.create(this.vertx, this.options.getPort(), this.options.getHost());
        proxy.proxyHandler((Handler<ProxyServer.Connection>)((Handler)conn -> {
            NetSocket clientSo = conn.clientSocket();
            clientSo.handler(buff -> clientSo.close());
            clientSo.resume();
        }));
        proxy.listen(8080, "localhost", (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v1 -> {
            this.options.setPort(8080).setHost("localhost");
            this.connector.accept(ctx.asyncAssertFailure(err -> async.complete()));
        }));
    }

    @Test
    public void testTx(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(conn -> conn.query("BEGIN").execute(ctx.asyncAssertSuccess(result1 -> {
            ctx.assertEquals((Object)0, (Object)result1.size());
            ctx.assertNotNull((Object)result1.iterator());
            conn.query("COMMIT").execute(ctx.asyncAssertSuccess(result2 -> {
                ctx.assertEquals((Object)0, (Object)result2.size());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testGrouping(TestContext ctx) {
        this.connector.accept(ctx.asyncAssertSuccess(conn -> ((SqlClientInternal)conn).group(client -> {
            client.query("SHOW TIME ZONE").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                Row row = (Row)res.iterator().next();
                ctx.assertEquals((Object)"PST8PDT", (Object)row.getString(0));
            }));
            conn.query("SET TIME ZONE 'PST8PDT'").execute(ctx.asyncAssertSuccess());
        })));
    }
}

