/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@DisplayName(value="Tests of VertxExtension")
class VertxExtensionTest {
    VertxExtensionTest() {
    }

    @Nested
    @ExtendWith(value={VertxExtension.class})
    @DisplayName(value="Test parameter injection at various (non-static) levels")
    class VertxInjectionTest {
        Vertx currentVertx;
        VertxTestContext previousTestContext;

        VertxInjectionTest() {
        }

        @BeforeEach
        void prepare(Vertx vertx, VertxTestContext testContext) {
            Assertions.assertThat((Object)testContext).isNotSameAs((Object)this.previousTestContext);
            this.previousTestContext = testContext;
            Assertions.assertThat((Object)this.currentVertx).isNotSameAs((Object)vertx);
            this.currentVertx = vertx;
            vertx.deployVerticle((Verticle)new UselessVerticle(), testContext.succeeding(id -> testContext.completeNow()));
        }

        @AfterEach
        void cleanup(Vertx vertx, VertxTestContext testContext) {
            Assertions.assertThat((Object)testContext).isNotSameAs((Object)this.previousTestContext);
            this.previousTestContext = testContext;
            ((IterableAssert)Assertions.assertThat((Iterable)vertx.deploymentIDs()).isNotEmpty()).hasSize(1);
            vertx.close(testContext.succeeding(v -> testContext.completeNow()));
        }

        @RepeatedTest(value=10)
        @DisplayName(value="Test the validity of references and scoping")
        void checkDeployments(Vertx vertx, VertxTestContext testContext) {
            Assertions.assertThat((Object)testContext).isNotSameAs((Object)this.previousTestContext);
            this.previousTestContext = testContext;
            Assertions.assertThat((Object)vertx).isSameAs((Object)this.currentVertx);
            ((IterableAssert)Assertions.assertThat((Iterable)vertx.deploymentIDs()).isNotEmpty()).hasSize(1);
            testContext.completeNow();
        }

        @Nested
        @DisplayName(value="A nested test")
        class NestedTest {
            NestedTest() {
            }

            @RepeatedTest(value=10)
            @DisplayName(value="Test the validity of references and scoping")
            void checkDeployments(Vertx vertx, VertxTestContext testContext) {
                Assertions.assertThat((Object)testContext).isNotSameAs((Object)VertxInjectionTest.this.previousTestContext);
                VertxInjectionTest.this.previousTestContext = testContext;
                Assertions.assertThat((Object)vertx).isSameAs((Object)VertxInjectionTest.this.currentVertx);
                ((IterableAssert)Assertions.assertThat((Iterable)vertx.deploymentIDs()).isNotEmpty()).hasSize(1);
                testContext.completeNow();
            }
        }
    }

    private static class UselessVerticle
    extends AbstractVerticle {
        private UselessVerticle() {
        }
    }

    @Nested
    @DisplayName(value="Tests that require embedding a JUnit launcher")
    class EmbeddedWithARunner {
        EmbeddedWithARunner() {
        }

        @Test
        @DisplayName(value="\u2699\ufe0f Check a test failure")
        void checkFailureTest() {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(FailureTest.class)}).build();
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            Assertions.assertThat((long)summary.getTestsStartedCount()).isEqualTo(1L);
            Assertions.assertThat((long)summary.getTestsFailedCount()).isEqualTo(1L);
            Assertions.assertThat((Throwable)((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException()).isInstanceOf(AssertionError.class);
        }

        @Test
        @DisplayName(value="\u2699\ufe0f Check a failure in the test method body rather than in a callback")
        void checkDirectFailure() {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(DirectFailureTest.class)}).build();
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            Assertions.assertThat((long)summary.getTestsStartedCount()).isEqualTo(1L);
            Assertions.assertThat((long)summary.getTestsFailedCount()).isEqualTo(1L);
            Assertions.assertThat((Throwable)((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException()).isInstanceOf(RuntimeException.class);
        }

        @Test
        @DisplayName(value="\u2699\ufe0f Check a test failure with an intermediate async result verifier")
        void checkFailureTestWithIntermediateAsyncVerifier() {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(FailureWithIntermediateAsyncVerifierTest.class)}).build();
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            Assertions.assertThat((long)summary.getTestsStartedCount()).isEqualTo(1L);
            Assertions.assertThat((long)summary.getTestsFailedCount()).isEqualTo(1L);
            Assertions.assertThat((Throwable)((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException()).isInstanceOf(AssertionError.class);
        }

        @Test
        @DisplayName(value="\u2699\ufe0f Check a timeout diagnosis")
        void checkTimeoutFailureTestWithIntermediateAsyncVerifier() {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(TimingOut.class)}).build();
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            Assertions.assertThat((long)summary.getTestsStartedCount()).isEqualTo(1L);
            Assertions.assertThat((long)summary.getTestsFailedCount()).isEqualTo(1L);
            Throwable exception = ((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exception).isInstanceOf(TimeoutException.class)).hasMessageContaining("checkpoint in file VertxExtensionTest.java");
        }

        @Nested
        @ExtendWith(value={VertxExtension.class})
        @DisplayName(value="\ud83d\udeab")
        class TimingOut {
            TimingOut() {
            }

            @Test
            @Tag(value="programmatic")
            @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
            void doNothing(VertxTestContext testContext) {
                testContext.checkpoint();
            }
        }

        @Nested
        @ExtendWith(value={VertxExtension.class})
        @DisplayName(value="\ud83d\udeab")
        class FailureWithIntermediateAsyncVerifierTest {
            FailureWithIntermediateAsyncVerifierTest() {
            }

            @Test
            @Tag(value="programmatic")
            void thisMustAlsoFail(Vertx vertx, VertxTestContext testContext) {
                vertx.executeBlocking(f -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    f.complete((Object)69);
                }, testContext.succeeding(i -> testContext.verify(() -> org.junit.jupiter.api.Assertions.assertEquals((Object)58, (Object)i))));
            }
        }

        @Nested
        @ExtendWith(value={VertxExtension.class})
        @DisplayName(value="\ud83d\udeab")
        class DirectFailureTest {
            DirectFailureTest() {
            }

            @Test
            @Tag(value="programmatic")
            @Timeout(value=1, timeUnit=TimeUnit.SECONDS)
            void thisMustFail(VertxTestContext testContext) {
                throw new RuntimeException("YOLO");
            }
        }

        @Nested
        @ExtendWith(value={VertxExtension.class})
        @DisplayName(value="\ud83d\udeab")
        class FailureTest {
            FailureTest() {
            }

            @Test
            @Tag(value="programmatic")
            void thisMustFail(Vertx vertx, VertxTestContext testContext) {
                testContext.verify(() -> org.junit.jupiter.api.Assertions.assertTrue((boolean)false));
            }
        }
    }

    @Nested
    @ExtendWith(value={VertxExtension.class})
    @Timeout(value=4500)
    @DisplayName(value="Specify timeouts")
    class SpecifyTimeout {
        SpecifyTimeout() {
        }

        @Test
        @DisplayName(value="Override a class-level timeout")
        @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
        void a(VertxTestContext context) throws InterruptedException {
            Thread.sleep(50L);
            context.completeNow();
        }

        @Test
        @DisplayName(value="Use the class-level timeout")
        void b(VertxTestContext context) throws InterruptedException {
            Thread.sleep(50L);
            context.completeNow();
        }
    }

    @Nested
    @ExtendWith(value={VertxExtension.class})
    @DisplayName(value="Basic test-level parameter injection smoke tests")
    class Injection {
        Injection() {
        }

        @Test
        @DisplayName(value="Inject a Vertx instance")
        void gimme_vertx(Vertx vertx) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)vertx);
        }

        @Test
        @DisplayName(value="Inject a VertxTestContext instance")
        void gimme_vertx_test_context(VertxTestContext context) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)context);
            context.completeNow();
        }

        @Test
        @DisplayName(value="Inject Vertx and VertxTestContext instances")
        void gimme_everything(Vertx vertx, VertxTestContext context) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)vertx);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)context);
            context.completeNow();
        }

        @Test
        @DisplayName(value="Inject 2 Vertx instances and check they are the same")
        void gimme_2_vertx(Vertx vertx1, Vertx vertx2) {
            org.junit.jupiter.api.Assertions.assertSame((Object)vertx1, (Object)vertx2);
        }

        @Test
        @DisplayName(value="Inject 2 VertxTestContext instances and check they are different")
        void gimme_2_vertx(VertxTestContext context1, VertxTestContext context2) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)context1, (Object)context2);
            context1.completeNow();
            context2.completeNow();
        }
    }
}

