/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@DisplayName(value="Test the injection in a complete lifecycle (esp., with @BeforeEach)")
@ExtendWith(value={VertxExtension.class})
class VertxExtensionCompleteLifecycleInjectionTest {
    static Vertx daVertx;
    static VertxTestContext daContext;

    VertxExtensionCompleteLifecycleInjectionTest() {
    }

    @BeforeAll
    static void inTheBeginning(Vertx vertx, VertxTestContext testContext) {
        daVertx = vertx;
        daContext = testContext;
        testContext.completeNow();
    }

    @BeforeEach
    void rightBefore(Vertx vertx, VertxTestContext testContext) {
        Assertions.assertThat((Object)vertx).isSameAs((Object)daVertx);
        Assertions.assertThat((Object)testContext).isNotSameAs((Object)daContext);
        testContext.completeNow();
    }

    @Test
    @DisplayName(value="Check that the Vertx instance is shared and that VertxTestContext is fresh")
    void test1(Vertx vertx, VertxTestContext testContext) {
        Assertions.assertThat((Object)vertx).isSameAs((Object)daVertx);
        Assertions.assertThat((Object)testContext).isNotSameAs((Object)daContext);
        testContext.completeNow();
    }

    @Test
    @DisplayName(value="Same test, same assumptions")
    void test2(Vertx vertx, VertxTestContext testContext) {
        Assertions.assertThat((Object)vertx).isSameAs((Object)daVertx);
        Assertions.assertThat((Object)testContext).isNotSameAs((Object)daContext);
        testContext.completeNow();
    }

    @AfterEach
    void rightAfter(Vertx vertx, VertxTestContext testContext) {
        Assertions.assertThat((Object)vertx).isSameAs((Object)daVertx);
        Assertions.assertThat((Object)testContext).isNotSameAs((Object)daContext);
        testContext.completeNow();
    }

    @AfterAll
    static void inTheEnd(Vertx vertx, VertxTestContext testContext) {
        Assertions.assertThat((Object)vertx).isSameAs((Object)daVertx);
        Assertions.assertThat((Object)testContext).isNotSameAs((Object)daContext);
        testContext.completeNow();
    }
}

