/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@DisplayName(value="Integration tests")
class IntegrationTest {
    IntegrationTest() {
    }

    @Nested
    @ExtendWith(value={VertxExtension.class})
    @DisplayName(value="Tests with parameter injection")
    class WithExtension {
        WithExtension() {
        }

        @Test
        @Timeout(value=10000)
        @DisplayName(value="Start a HTTP server, make 10 client requests, and use several checkpoints")
        void start_and_request_http_server_with_checkpoints(Vertx vertx, VertxTestContext testContext) {
            Checkpoint serverStarted = testContext.checkpoint();
            Checkpoint requestsServed = testContext.checkpoint(10);
            Checkpoint responsesReceived = testContext.checkpoint(10);
            vertx.createHttpServer().requestHandler(req -> {
                req.response().end("Ok");
                requestsServed.flag();
            }).listen(8080, ar -> {
                if (ar.failed()) {
                    testContext.failNow(ar.cause());
                } else {
                    serverStarted.flag();
                }
            });
            HttpClient client = vertx.createHttpClient();
            for (int i = 0; i < 10; ++i) {
                client.request(HttpMethod.GET, 8080, "localhost", "/").flatMap(req -> req.send().compose(HttpClientResponse::body)).onFailure(arg_0 -> ((VertxTestContext)testContext).failNow(arg_0)).onSuccess(buffer -> {
                    testContext.verify(() -> Assertions.assertThat((String)buffer.toString()).isEqualTo("Ok"));
                    responsesReceived.flag();
                });
            }
        }
    }

    @Nested
    @DisplayName(value="Tests without parameter injection and explicit Vertx and VertxTestContext instances")
    class Naked {
        Naked() {
        }

        @Test
        @DisplayName(value="Start a HTTP server")
        void start_http_server() throws InterruptedException {
            VertxTestContext testContext = new VertxTestContext();
            Vertx vertx = Vertx.vertx();
            vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(16969, testContext.succeeding(ar -> testContext.completeNow()));
            Assertions.assertThat((boolean)testContext.awaitCompletion(5L, TimeUnit.SECONDS)).isTrue();
            this.closeVertx(vertx);
        }

        @Test
        @DisplayName(value="Start a HTTP server, then issue a HTTP client request and check the response")
        void vertx_check_http_server_response() throws InterruptedException {
            Vertx vertx = Vertx.vertx();
            VertxTestContext testContext = new VertxTestContext();
            vertx.deployVerticle((Verticle)new HttpServerVerticle(), testContext.succeeding(id -> {
                HttpClient client = vertx.createHttpClient();
                client.request(HttpMethod.GET, 8080, "localhost", "/").flatMap(req -> req.send().compose(HttpClientResponse::body)).onFailure(arg_0 -> ((VertxTestContext)testContext).failNow(arg_0)).onSuccess(buffer -> testContext.verify(() -> {
                    Assertions.assertThat((String)buffer.toString()).isEqualTo("Plop");
                    testContext.completeNow();
                }));
            }));
            Assertions.assertThat((boolean)testContext.awaitCompletion(5L, TimeUnit.SECONDS)).isTrue();
            this.closeVertx(vertx);
        }

        private void closeVertx(Vertx vertx) throws InterruptedException {
            CountDownLatch latch = new CountDownLatch(1);
            vertx.close(ar -> latch.countDown());
            Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).isTrue();
        }
    }

    static class HttpServerVerticle
    extends AbstractVerticle {
        HttpServerVerticle() {
        }

        public void start(Promise<Void> startFuture) throws Exception {
            this.vertx.createHttpServer().requestHandler(request -> request.response().end("Plop")).listen(8080, ar -> {
                if (ar.succeeded()) {
                    startFuture.complete();
                } else {
                    startFuture.fail(ar.cause());
                }
            });
        }
    }
}

