/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.CountingCheckpoint;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

@DisplayName(value="Unit test for CountingCheckpoint")
class CountingCheckpointTest {
    private static final Consumer<Checkpoint> NOOP = c -> {};

    CountingCheckpointTest() {
    }

    @Test
    @DisplayName(value="Smoke tests")
    void smoke_test() {
        AtomicBoolean success = new AtomicBoolean(false);
        AtomicReference witness = new AtomicReference();
        Consumer<Checkpoint> consumer = c -> {
            success.set(true);
            witness.set(c);
        };
        CountingCheckpoint checkpoint = CountingCheckpoint.laxCountingCheckpoint(consumer, (int)3);
        checkpoint.flag();
        Assertions.assertThat((AtomicBoolean)success).isFalse();
        Assertions.assertThat(witness).hasValue(null);
        Assertions.assertThat((boolean)checkpoint.satisfied()).isFalse();
        checkpoint.flag();
        Assertions.assertThat((AtomicBoolean)success).isFalse();
        Assertions.assertThat(witness).hasValue(null);
        Assertions.assertThat((boolean)checkpoint.satisfied()).isFalse();
        checkpoint.flag();
        Assertions.assertThat((AtomicBoolean)success).isTrue();
        Assertions.assertThat(witness).hasValue((Object)checkpoint);
        Assertions.assertThat((boolean)checkpoint.satisfied()).isTrue();
    }

    @Test
    @DisplayName(value="Refuse null triggers")
    void refuse_null_triggers() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> CountingCheckpoint.laxCountingCheckpoint(null, (int)1));
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> CountingCheckpoint.strictCountingCheckpoint(v -> {}, null, (int)1));
    }

    @Test
    @DisplayName(value="Refuse having 0 expected passes")
    void refuse_zero_passes() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> CountingCheckpoint.laxCountingCheckpoint(NOOP, (int)0));
    }

    @Test
    @DisplayName(value="Refuse having negative expected passes")
    void refuse_negative_passes() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> CountingCheckpoint.laxCountingCheckpoint(NOOP, (int)-1));
    }

    @Test
    @DisplayName(value="Check of a lax checkpoint")
    void check_lax_checkpoint() {
        CountingCheckpoint checkpoint = CountingCheckpoint.laxCountingCheckpoint(NOOP, (int)1);
        checkpoint.flag();
        checkpoint.flag();
    }

    @Test
    @DisplayName(value="Check of a strict checkpoint")
    void check_strict_checkpoint() {
        AtomicReference box = new AtomicReference();
        CountingCheckpoint checkpoint = CountingCheckpoint.strictCountingCheckpoint(NOOP, box::set, (int)1);
        Assertions.assertThat((boolean)checkpoint.satisfied()).isFalse();
        checkpoint.flag();
        Assertions.assertThat(box).hasValue(null);
        Assertions.assertThat((boolean)checkpoint.satisfied()).isTrue();
        checkpoint.flag();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)box.get())).isNotNull()).isInstanceOf(IllegalStateException.class)).hasMessage("Strict checkpoint flagged too many times");
        Assertions.assertThat((boolean)checkpoint.satisfied()).isTrue();
    }
}

