/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@DisplayName(value="Test multiple @BeforeEach methods")
class AsyncBeforeEachTest {
    private boolean started1;
    private boolean started2;
    private final AtomicInteger count = new AtomicInteger();

    AsyncBeforeEachTest() {
    }

    @BeforeEach
    void before1(VertxTestContext context, Vertx vertx) {
        int c = this.count.get();
        boolean s = this.started2;
        if (c == 1) {
            Assertions.assertTrue((boolean)s);
        }
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(20L, id -> {
            this.started1 = true;
            this.count.incrementAndGet();
            checkpoint.flag();
        });
    }

    @BeforeEach
    void before2(VertxTestContext context, Vertx vertx) {
        int c = this.count.get();
        boolean s = this.started1;
        if (c == 1) {
            Assertions.assertTrue((boolean)s);
        }
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(20L, id -> {
            this.started2 = true;
            this.count.incrementAndGet();
            checkpoint.flag();
        });
    }

    @RepeatedTest(value=10)
    void check_async_before_completed() {
        Assertions.assertEquals((int)2, (int)this.count.get());
        Assertions.assertTrue((boolean)this.started1);
        Assertions.assertTrue((boolean)this.started2);
    }
}

