/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@DisplayName(value="Test @BeforeEach and @BeforeAll methods")
class AsyncBeforeCombinedTest {
    private static volatile int step;

    AsyncBeforeCombinedTest() {
    }

    @BeforeAll
    static void before_all(VertxTestContext context, Vertx vertx) {
        Assertions.assertEquals((int)0, (int)step);
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(200L, id -> {
            step = 1;
            checkpoint.flag();
        });
    }

    @BeforeEach
    void before_each(VertxTestContext context, Vertx vertx) {
        Assertions.assertEquals((int)1, (int)step);
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(200L, id -> {
            step = 2;
            checkpoint.flag();
        });
    }

    @Test
    void check_async_before_completed() {
        Assertions.assertEquals((int)2, (int)step);
    }
}

